/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Builder
implements Receiver {
    public static final int STANDARD_TREE = 0;
    public static final int TINY_TREE = 1;
    protected Configuration config;
    protected NamePool namePool;
    protected String systemId;
    protected LocationProvider locator;
    protected DocumentInfo currentDocument;
    protected boolean lineNumbering;
    protected boolean started = false;
    protected boolean timing = false;
    private long startTime;

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.lineNumbering = configuration.isLineNumbering();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public void setDocumentLocator(LocationProvider locationProvider) {
        this.locator = locationProvider;
    }

    public LocationProvider getDocumentLocator() {
        return this.locator;
    }

    public void setRootNode(DocumentInfo documentInfo) {
        this.currentDocument = documentInfo;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void open() throws XPathException {
        if (this.timing) {
            System.err.println("Building tree for " + this.getSystemId() + " using " + this.getClass());
            this.startTime = new Date().getTime();
        }
    }

    public void close() throws XPathException {
        if (this.timing) {
            long l = new Date().getTime();
            System.err.println("Tree built in " + (l - this.startTime) + " milliseconds");
            if (this.currentDocument instanceof TinyDocumentImpl) {
                ((TinyDocumentImpl)this.currentDocument).showSize();
            }
            this.startTime = l;
        }
    }

    public void startDocument(int n) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public DocumentInfo getCurrentDocument() {
        return this.currentDocument;
    }

    public static NodeInfo build(Source source, Stripper stripper, Configuration configuration) throws XPathException {
        if (source == null) {
            throw new NullPointerException("Source supplied to builder cannot be null");
        }
        if (source instanceof DOMSource || source instanceof NodeInfo) {
            Object object;
            NodeInfo nodeInfo;
            Object object2;
            if (source instanceof DOMSource) {
                object2 = ((DOMSource)source).getNode();
                if (object2 instanceof NodeInfo) {
                    nodeInfo = (NodeInfo)object2;
                } else {
                    object = object2 instanceof Document ? (Document)object2 : object2.getOwnerDocument();
                    DocumentWrapper documentWrapper = new DocumentWrapper((Document)object, source.getSystemId(), configuration);
                    nodeInfo = documentWrapper.wrap((Node)object2);
                }
            } else {
                nodeInfo = (NodeInfo)source;
            }
            if (stripper != null) {
                object2 = nodeInfo.getDocumentRoot();
                object = new StrippedDocument((DocumentInfo)object2, stripper);
                nodeInfo = ((StrippedDocument)object).wrap(nodeInfo);
            }
            return nodeInfo;
        }
        Builder builder = configuration.getTreeModel() == 1 ? new TinyBuilder() : new TreeBuilder();
        builder.setConfiguration(configuration);
        builder.setLineNumbering(configuration.isLineNumbering());
        Receiver receiver = builder;
        if (stripper != null) {
            stripper.setUnderlyingReceiver(builder);
            receiver = stripper;
        }
        try {
            new Sender(configuration).send(source, receiver);
        }
        catch (XPathException xPathException) {
            throw new DynamicError(xPathException);
        }
        DocumentInfo documentInfo = builder.getCurrentDocument();
        return documentInfo;
    }
}

