/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AppendExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.xpath.XPathException;

public final class CardinalityChecker
extends UnaryExpression
implements MappingFunction {
    private int requiredCardinality = -1;
    private RoleLocator role;

    public CardinalityChecker(Expression expression, int n, RoleLocator roleLocator) {
        super(expression);
        this.requiredCardinality = n;
        this.role = roleLocator;
        this.computeStaticProperties();
        this.adoptChildExpression(expression);
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand = this.operand.analyze(staticContext, itemType);
        if (this.requiredCardinality == 1792) {
            return this.operand;
        }
        if (Cardinality.subsumes(this.requiredCardinality, this.operand.getCardinality())) {
            return this.operand;
        }
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        if (!Cardinality.allowsZero(this.requiredCardinality)) {
            ObjectValue objectValue = new ObjectValue(this);
            sequenceIterator = new AppendExpression.AppendIterator(sequenceIterator, objectValue, xPathContext);
        }
        return new MappingIterator(sequenceIterator, this, null, sequenceIterator);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        int n = ((SequenceIterator)object).position();
        if (item instanceof ObjectValue && ((ObjectValue)item).getObject() == this) {
            if (n == 1) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), xPathContext);
            }
            return null;
        }
        if (n == 2 && !Cardinality.allowsMany(this.requiredCardinality)) {
            this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), xPathContext);
            return null;
        }
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.operand.iterate(xPathContext);
        Item item2 = null;
        while ((item = sequenceIterator.next()) != null) {
            if (item2 != null) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), xPathContext);
                return null;
            }
            item2 = item;
        }
        if (item2 == null && !Cardinality.allowsZero(this.requiredCardinality)) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), xPathContext);
            return null;
        }
        return item2;
    }

    public ItemType getItemType() {
        return this.operand.getItemType();
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.requiredCardinality == ((CardinalityChecker)object).requiredCardinality;
    }

    public String displayOperator(NamePool namePool) {
        return "checkCardinality (" + Cardinality.toString(this.requiredCardinality) + ')';
    }
}

