/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PositionIterator;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Last;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public final class FilterExpression
extends ComputedExpression {
    private Expression start;
    private Expression filter;
    private int filterDependencies;
    private boolean filterIsPositional;

    public FilterExpression(Expression expression, Expression expression2, StaticContext staticContext) throws StaticError {
        this.start = expression;
        this.filter = expression2;
        this.adoptChildExpression(expression);
        this.adoptChildExpression(expression2);
        try {
            this.filterDependencies = expression2.simplify(staticContext).getDependencies();
        }
        catch (XPathException xPathException) {
            throw xPathException.makeStatic();
        }
    }

    public ItemType getItemType() {
        return this.start.getItemType();
    }

    public Expression getBaseExpression() {
        return this.start;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public boolean isPositional() {
        return FilterExpression.isPositionalFilter(this.filter);
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.start = this.start.simplify(staticContext);
        this.filter = this.filter.simplify(staticContext);
        if (this.start instanceof EmptySequence) {
            return this.start;
        }
        if (this.filter instanceof Value && !(this.filter instanceof NumericValue)) {
            try {
                if (this.filter.effectiveBooleanValue(null)) {
                    return this.start;
                }
                return EmptySequence.getInstance();
            }
            catch (XPathException xPathException) {
                throw new StaticError(xPathException);
            }
        }
        if (this.filter instanceof Last) {
            this.filter = new IsLastExpression(true);
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        Object object;
        this.start = this.start.analyze(staticContext, itemType);
        this.filter = this.filter.analyze(staticContext, this.start.getItemType());
        this.filter = ExpressionTool.unsorted(this.filter, false);
        if (this.filter instanceof IntegerValue && ((IntegerValue)this.filter).longValue() == 1L) {
            return new FirstItemExpression(this.start);
        }
        if (this.filter instanceof PositionRange) {
            object = (PositionRange)this.filter;
            int n = ((PositionRange)object).getMinPosition();
            int n2 = ((PositionRange)object).getMaxPosition();
            if (n == 1 && n2 == 1) {
                return new FirstItemExpression(this.start);
            }
            if (n2 == Integer.MAX_VALUE) {
                return new TailExpression(this.start, n);
            }
        }
        this.filterIsPositional = FilterExpression.isPositionalFilter(this.filter);
        if (this.filterIsPositional && this.filter instanceof BooleanExpression && ((BooleanExpression)this.filter).operator == 10) {
            object = (BooleanExpression)this.filter;
            if (FilterExpression.isExplicitlyPositional(((BooleanExpression)object).operand0) && !FilterExpression.isExplicitlyPositional(((BooleanExpression)object).operand1)) {
                Expression expression = FilterExpression.forceToBoolean(((BooleanExpression)object).operand0, staticContext.getNamePool());
                Expression expression2 = FilterExpression.forceToBoolean(((BooleanExpression)object).operand1, staticContext.getNamePool());
                FilterExpression filterExpression = new FilterExpression(this.start, expression, staticContext);
                FilterExpression filterExpression2 = new FilterExpression(filterExpression, expression2, staticContext);
                return filterExpression2.analyze(staticContext, itemType);
            }
            if (FilterExpression.isExplicitlyPositional(((BooleanExpression)object).operand1) && !FilterExpression.isExplicitlyPositional(((BooleanExpression)object).operand0)) {
                Expression expression = FilterExpression.forceToBoolean(((BooleanExpression)object).operand0, staticContext.getNamePool());
                Expression expression3 = FilterExpression.forceToBoolean(((BooleanExpression)object).operand1, staticContext.getNamePool());
                FilterExpression filterExpression = new FilterExpression(this.start, expression3, staticContext);
                FilterExpression filterExpression3 = new FilterExpression(filterExpression, expression, staticContext);
                return filterExpression3.analyze(staticContext, itemType);
            }
        }
        object = new PromotionOffer();
        ((PromotionOffer)object).action = 10;
        ((PromotionOffer)object).promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        ((PromotionOffer)object).containingExpression = this;
        this.filter = this.filter.promote((PromotionOffer)object);
        if (((PromotionOffer)object).containingExpression instanceof LetExpression) {
            ((PromotionOffer)object).containingExpression = ((PromotionOffer)object).containingExpression.analyze(staticContext, itemType);
        }
        return ((PromotionOffer)object).containingExpression;
    }

    private static Expression forceToBoolean(Expression expression, NamePool namePool) {
        if (expression.getItemType().getPrimitiveType() == 514) {
            return expression;
        }
        Expression[] expressionArray = new Expression[]{expression};
        FunctionCall functionCall = SystemFunction.makeSystemFunction("boolean", namePool);
        functionCall.setArguments(expressionArray);
        return functionCall;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13 || !this.filterIsPositional) {
            this.start = this.start.promote(promotionOffer);
        }
        if (promotionOffer.action == 12) {
            this.filter = this.filter.promote(promotionOffer);
        }
        return this;
    }

    private static boolean isPositionalFilter(Expression expression) {
        ItemType itemType = expression.getItemType();
        return itemType == Type.ANY_ATOMIC_TYPE || itemType instanceof AnyItemType || Type.isSubType(itemType, Type.NUMBER_TYPE) || FilterExpression.isExplicitlyPositional(expression);
    }

    private static boolean isExplicitlyPositional(Expression expression) {
        return (expression.getDependencies() & 0xC) != 0;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.start, this.filter);
    }

    public int computeCardinality() {
        PositionRange positionRange;
        if (this.filter instanceof NumericValue) {
            return 768;
        }
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            return 768;
        }
        if (this.filter instanceof PositionRange && (positionRange = (PositionRange)this.filter).getMinPosition() == positionRange.getMaxPosition()) {
            return 768;
        }
        if (this.filter instanceof IsLastExpression && ((IsLastExpression)this.filter).getCondition()) {
            return 768;
        }
        int n = this.start.getCardinality();
        switch (n) {
            case 1536: {
                return 1792;
            }
            case 512: {
                return 768;
            }
        }
        return n;
    }

    public int computeSpecialProperties() {
        return this.start.getSpecialProperties();
    }

    public boolean equals(Object object) {
        if (object instanceof FilterExpression) {
            FilterExpression filterExpression = (FilterExpression)object;
            return this.start.equals(filterExpression.start) && this.filter.equals(filterExpression.filter);
        }
        return false;
    }

    public int hashCode() {
        return "FilterExpression".hashCode() + this.start.hashCode() + this.filter.hashCode();
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator;
        if (this.start instanceof SequenceValue && this.filter instanceof IntegerValue) {
            int n = (int)((IntegerValue)this.filter).longValue();
            return SingletonIterator.makeIterator(((SequenceValue)this.start).itemAt(n - 1));
        }
        SequenceIterator sequenceIterator2 = this.start.iterate(xPathContext);
        if (sequenceIterator2 instanceof EmptyIterator) {
            return sequenceIterator2;
        }
        Expression expression = this.filter;
        if (this.filter instanceof VariableReference) {
            expression = ((VariableReference)this.filter).evaluateVariable(xPathContext);
        }
        if (expression instanceof Value) {
            if (expression instanceof NumericValue) {
                if (((NumericValue)expression).isWholeNumber()) {
                    int n = (int)((NumericValue)expression).longValue();
                    if (n >= 1) {
                        return PositionIterator.make(sequenceIterator2, n, n);
                    }
                    return EmptyIterator.getInstance();
                }
                return EmptyIterator.getInstance();
            }
            if (expression.effectiveBooleanValue(xPathContext)) {
                return sequenceIterator2;
            }
            return EmptyIterator.getInstance();
        }
        if (this.filter instanceof PositionRange) {
            PositionRange positionRange = (PositionRange)this.filter;
            sequenceIterator = PositionIterator.make(sequenceIterator2, positionRange.getMinPosition(), positionRange.getMaxPosition());
        } else {
            sequenceIterator = this.filterIsPositional ? new FilterIterator(sequenceIterator2, this.filter, xPathContext) : new FilterIterator.NonNumeric(sequenceIterator2, this.filter, xPathContext);
        }
        return sequenceIterator;
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.filterDependencies & 0x21;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "filter []");
        this.start.display(n + 1, namePool, printStream);
        this.filter.display(n + 1, namePool, printStream);
    }
}

