/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.Err;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.DummyNamespaceResolver;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.XPathException;

public final class FixedAttribute
extends SimpleNodeConstructor {
    private int nameCode;
    private SimpleType schemaType;
    private int annotation;
    private int options;
    private int validationAction;

    public FixedAttribute(int n, int n2, SimpleType simpleType, int n3) {
        this.nameCode = n;
        this.schemaType = simpleType;
        this.annotation = n3;
        this.validationAction = n2;
        this.options = 0;
    }

    public int getInstructionNameCode() {
        return 131;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public void setSelect(Expression expression) throws StaticError {
        super.setSelect(expression);
        if (expression instanceof AtomicValue && this.schemaType != null && !this.schemaType.isNamespaceSensitive()) {
            String string = ((AtomicValue)expression).getStringValue();
            try {
                this.schemaType.validateContent(string, DummyNamespaceResolver.getInstance());
            }
            catch (ValidationException validationException) {
                throw new StaticError("Attribute value " + Err.wrap(string, 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + validationException.getMessage());
            }
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        instructionDetails.setConstructType(2007);
        instructionDetails.setObjectNameCode(this.nameCode);
        return instructionDetails;
    }

    public ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    public int getCardinality() {
        return 512;
    }

    public void typeCheck(StaticContext staticContext, ItemType itemType) {
    }

    protected int evaluateNameCode(XPathContext xPathContext) {
        return this.nameCode;
    }

    /*
     * Unable to fully structure code
     */
    public TailCall processLeavingTail(XPathContext var1_1) throws XPathException {
        var2_2 = var1_1.getController();
        var3_3 = var1_1.getReceiver();
        var4_4 = this.options;
        var5_5 = this.annotation;
        var6_6 = this.expandChildren(var1_1).toString();
        if (this.schemaType != null) {
            try {
                this.schemaType.validateContent(var6_6, DummyNamespaceResolver.getInstance());
                if (!this.schemaType.isNamespaceSensitive()) ** GOTO lbl18
                var4_4 |= 512;
            }
            catch (ValidationException var7_7) {
                throw new ValidationException("Attribute value " + Err.wrap(var6_6, 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + var7_7.getMessage());
            }
        } else if (this.validationAction == 1 || this.validationAction == 2) {
            var7_8 = var2_2.getConfiguration().validateAttribute(this.nameCode, var6_6, this.validationAction);
            var5_5 = (int)(var7_8 & -1L);
            var4_4 |= (int)(var7_8 >> 32);
        }
lbl18:
        // 5 sources

        try {
            var3_3.attribute(this.nameCode, var5_5, var6_6, this.locationId, var4_4);
        }
        catch (NoOpenStartTagException var7_9) {
            var8_10 = new DynamicError("Cannot write an attribute node when no element start tag is open");
            var8_10.setXPathContext(var1_1);
            var8_10.setErrorCode(var7_9.getErrorCode());
            var1_1.getController().recoverableError(var8_10);
        }
        catch (XPathException var8_11) {
            throw Instruction.dynamicError(this, var8_11, var1_1);
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Orphan orphan;
        block6: {
            orphan = (Orphan)super.evaluateItem(xPathContext);
            if (this.schemaType != null) {
                try {
                    this.schemaType.validateContent(orphan.getStringValue(), DummyNamespaceResolver.getInstance());
                    orphan.setTypeAnnotation(this.schemaType.getFingerprint());
                    if (this.schemaType.isNamespaceSensitive()) {
                        throw new DynamicError("Cannot validate a parentless attribute whose content is namespace-sensitive");
                    }
                    break block6;
                }
                catch (ValidationException validationException) {
                    throw new ValidationException("Attribute value " + Err.wrap(orphan.getStringValue(), 4) + " does not the match the required type " + this.schemaType.getDescription() + ". " + validationException.getMessage());
                }
            }
            if (this.validationAction == 1 || this.validationAction == 2) {
                long l = xPathContext.getController().getConfiguration().validateAttribute(this.nameCode, orphan.getStringValue(), this.validationAction);
                int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                int n2 = (int)(l >> 32);
                if (n2 != 0) {
                    throw new DynamicError("Cannot validate a parentless attribute whose content is namespace-sensitive");
                }
                orphan.setTypeAnnotation(n);
            }
        }
        return orphan;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "attribute ");
        printStream.println(ExpressionTool.indent(n + 1) + "name " + (namePool == null ? this.nameCode + "" : namePool.getDisplayName(this.nameCode)));
        super.display(n + 1, namePool, printStream);
    }
}

