/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.ElementCreator;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.xpath.XPathException;

public class FixedElement
extends ElementCreator {
    private int nameCode;
    protected int[] namespaceCodes = null;

    public FixedElement(int n, int[] nArray, AttributeSet[] attributeSetArray, boolean bl, SchemaType schemaType, int n2) {
        this.nameCode = n;
        this.namespaceCodes = nArray;
        this.useAttributeSets = attributeSetArray;
        this.inheritNamespaces = bl;
        this.schemaType = schemaType;
        this.validation = n2;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = (InstructionDetails)super.getInstructionInfo();
        instructionDetails.setConstructType(2006);
        instructionDetails.setObjectNameCode(this.nameCode);
        return instructionDetails;
    }

    protected int getNameCode(XPathContext xPathContext) {
        return this.nameCode;
    }

    protected void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver) throws XPathException {
        if (this.namespaceCodes != null) {
            int n = 0;
            while (n < this.namespaceCodes.length) {
                receiver.namespace(this.namespaceCodes[n], 0);
                ++n;
            }
        }
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "element ");
        printStream.println(ExpressionTool.indent(n + 1) + "name " + (namePool == null ? this.nameCode + "" : namePool.getDisplayName(this.nameCode)));
        if (this.children == null || this.children.length == 0) {
            printStream.println(ExpressionTool.indent(n + 1) + "empty content");
        } else {
            InstructionWithChildren.displayChildren(this.children, n + 1, namePool, printStream);
        }
    }
}

