/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class GlobalParam
extends GlobalVariable {
    public int getInstructionNameCode() {
        return 170;
    }

    public Value evaluateVariable(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        Bindery bindery = controller.getBindery();
        boolean bl = bindery.useGlobalParameter(this.getVariableFingerprint(), this);
        if (bl) {
            return bindery.getGlobalVariableValue(this);
        }
        if (this.isRequiredParam()) {
            DynamicError dynamicError = new DynamicError("No value supplied for required parameter $" + xPathContext.getController().getNamePool().getDisplayName(this.getVariableFingerprint()));
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setLocator(this.getSourceLocator());
            dynamicError.setErrorCode("XT0050");
            throw dynamicError;
        }
        try {
            bindery.setExecuting(this, true);
            Value value = this.getSelectValue(xPathContext);
            bindery.defineGlobalVariable(this, value);
            bindery.setExecuting(this, false);
            return value;
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof XPathException.Circularity) {
                DynamicError dynamicError = new DynamicError("Circular definition of parameter " + this.getVariableName());
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XT0640");
                throw dynamicError;
            }
            throw xPathException;
        }
    }
}

