/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class GlobalVariable
extends GeneralVariable
implements Container {
    private Executable executable;
    private SlotManager stackFrameMap = null;

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public void setContainsLocals(SlotManager slotManager) {
        this.stackFrameMap = slotManager;
    }

    public boolean isGlobal() {
        return true;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        return null;
    }

    public Value getSelectValue(XPathContext xPathContext) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)"*** No select expression!!");
        }
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(SingletonIterator.makeIterator(xPathContextMajor.getController().getPrincipalSourceDocument()));
        if (this.stackFrameMap != null) {
            xPathContextMajor.openStackFrame(this.stackFrameMap);
        }
        return ExpressionTool.eagerEvaluate(this.select, xPathContextMajor);
    }

    public Value evaluateVariable(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        Bindery bindery = controller.getBindery();
        Value value = bindery.getGlobalVariableValue(this);
        if (value != null) {
            return value;
        }
        try {
            bindery.setExecuting(this, true);
            Value value2 = this.getSelectValue(xPathContext);
            bindery.defineGlobalVariable(this, value2);
            bindery.setExecuting(this, false);
            return value2;
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof XPathException.Circularity) {
                DynamicError dynamicError = new DynamicError("Circular definition of variable " + this.getVariableName());
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setErrorCode("XT0640");
                throw dynamicError;
            }
            throw xPathException;
        }
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(185);
        instructionDetails.setObjectNameCode(this.getVariableFingerprint());
        instructionDetails.setProperty("expression", this);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setColumnNumber(this.getColumnNumber());
        return instructionDetails;
    }
}

