/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public abstract class InstructionWithChildren
extends Instruction {
    protected Expression[] children;

    public void setChildren(Expression[] expressionArray) {
        if (expressionArray == null || expressionArray.length == 0) {
            this.children = null;
        } else {
            this.children = expressionArray;
            int n = 0;
            while (n < expressionArray.length) {
                this.adoptChildExpression(expressionArray[n]);
                ++n;
            }
        }
    }

    public Expression[] getChildren() {
        return this.children;
    }

    public static void displayChildren(Expression[] expressionArray, int n, NamePool namePool, PrintStream printStream) {
        if (expressionArray != null) {
            int n2 = 0;
            while (n2 < expressionArray.length) {
                expressionArray[n2].display(n + 1, namePool, printStream);
                ++n2;
            }
        }
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n] = this.children[n].simplify(staticContext);
                ++n;
            }
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n] = this.children[n].analyze(staticContext, itemType);
                ++n;
            }
        }
        return this;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                this.children[n] = this.children[n].promote(promotionOffer);
                ++n;
            }
        }
    }

    public Iterator iterateSubExpressions() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Arrays.asList(this.children).iterator();
    }

    protected void processChildren(XPathContext xPathContext) throws XPathException {
        if (this.children == null) {
            return;
        }
        int n = 0;
        while (n < this.children.length) {
            try {
                this.children[n].process(xPathContext);
            }
            catch (XPathException xPathException) {
                if (xPathException instanceof DynamicError) {
                    if (xPathException.getLocator() == null) {
                        xPathException.setLocator(ExpressionTool.getLocator(this.children[n]));
                    }
                    if (((DynamicError)xPathException).getXPathContext() == null) {
                        ((DynamicError)xPathException).setXPathContext(xPathContext);
                    }
                    throw xPathException;
                }
                throw Instruction.dynamicError(ExpressionTool.getLocator(this.children[n]), xPathException, xPathContext);
            }
            ++n;
        }
    }

    protected TailCall processChildrenLeavingTail(XPathContext xPathContext) throws XPathException {
        if (this.children == null) {
            return null;
        }
        TailCall tailCall = null;
        int n = 0;
        while (n < this.children.length) {
            try {
                if (this.children[n] instanceof Instruction) {
                    tailCall = ((Instruction)this.children[n]).processLeavingTail(xPathContext);
                } else {
                    this.children[n].process(xPathContext);
                    tailCall = null;
                }
            }
            catch (DynamicError dynamicError) {
                if (dynamicError.getXPathContext() == null) {
                    dynamicError.setXPathContext(xPathContext);
                }
                if (dynamicError.getLocator() == null) {
                    dynamicError.setLocator(ExpressionTool.getLocator(this.children[n]));
                }
                throw dynamicError;
            }
            ++n;
        }
        return tailCall;
    }
}

