/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class Namespace
extends SimpleNodeConstructor {
    private Expression name;

    public Namespace(Expression expression) {
        this.name = expression;
    }

    public int getInstructionNameCode() {
        return 161;
    }

    public ItemType getItemType() {
        return NodeKindTest.NAMESPACE;
    }

    public int getCardinality() {
        return 512;
    }

    protected void promoteInst(PromotionOffer promotionOffer) {
    }

    public void typeCheck(StaticContext staticContext, ItemType itemType) {
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(6);
        if (this.children != null) {
            arrayList.addAll(Arrays.asList(this.children));
        }
        if (this.select != null) {
            arrayList.add(this.select);
        }
        if (this.separator != null && !(this.separator instanceof StringValue)) {
            arrayList.add(this.separator);
        }
        arrayList.add(this.name);
        return arrayList.iterator();
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        String string = this.name.evaluateAsString(xPathContext);
        if (!string.equals("") && !XMLChar.isValidNCName(string)) {
            DynamicError dynamicError = new DynamicError("Namespace prefix is invalid: " + string, this);
            dynamicError.setErrorCode("XT0920");
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
            return null;
        }
        if (string.equals("xml") || string.equals("xmlns")) {
            DynamicError dynamicError = new DynamicError("Namespace prefix '" + string + "' is not allowed", this);
            dynamicError.setErrorCode("XT0920");
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
            return null;
        }
        String string2 = this.expandChildren(xPathContext).toString();
        if (string2.equals("")) {
            DynamicError dynamicError = new DynamicError("Namespace URI is an empty string", this);
            dynamicError.setErrorCode("XT0930");
            dynamicError.setXPathContext(xPathContext);
            xPathContext.getController().recoverableError(dynamicError);
            return null;
        }
        int n = controller.getNamePool().allocateNamespaceCode(string, string2);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        sequenceReceiver.namespace(n, 32);
        return null;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        printStream.println(ExpressionTool.indent(n) + "namespace");
        this.name.display(n + 1, namePool, printStream);
        super.display(n + 1, namePool, printStream);
    }
}

