/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PathExpression;
import net.sf.saxon.expr.PositionRange;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = null;
    protected int numberOfFilters = 0;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;
    private boolean usesCurrent = false;

    public void addFilter(Expression expression) {
        if (this.filters == null) {
            this.filters = new Expression[3];
        } else if (this.numberOfFilters == this.filters.length) {
            Expression[] expressionArray = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, expressionArray, 0, this.numberOfFilters);
            this.filters = expressionArray;
        }
        this.filters[this.numberOfFilters++] = expression;
        ExpressionTool.makeParentReferences(expression);
        if (expression instanceof ComputedExpression) {
            ((ComputedExpression)expression).setParentExpression(this);
        }
    }

    public Pattern simplify(StaticContext staticContext) throws XPathException {
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters == null) {
            NodeTestPattern nodeTestPattern = new NodeTestPattern(this.nodeTest);
            nodeTestPattern.setSystemId(this.getSystemId());
            nodeTestPattern.setLineNumber(this.getLineNumber());
            return nodeTestPattern;
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify(staticContext);
            if (this.parentPattern instanceof LocationPathPattern) {
                this.usesCurrent = ((LocationPathPattern)this.parentPattern).usesCurrent;
            }
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify(staticContext);
            if (this.ancestorPattern instanceof LocationPathPattern) {
                this.usesCurrent = ((LocationPathPattern)this.ancestorPattern).usesCurrent;
            }
        }
        if (this.filters != null) {
            int n = this.numberOfFilters - 1;
            while (n >= 0) {
                Expression expression;
                this.filters[n] = expression = this.filters[n].simplify(staticContext);
                if ((expression.getDependencies() & 1) != 0) {
                    this.usesCurrent = true;
                }
                --n;
            }
        }
        return this;
    }

    public Pattern typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.typeCheck(staticContext, itemType);
        } else if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.typeCheck(staticContext, itemType);
        }
        if (this.filters != null) {
            int n = this.numberOfFilters - 1;
            while (n >= 0) {
                Expression expression;
                this.filters[n] = expression = this.filters[n].analyze(staticContext, itemType);
                if (expression instanceof BooleanValue && ((BooleanValue)expression).getBooleanValue() && n == this.numberOfFilters - 1) {
                    --this.numberOfFilters;
                }
                ((ExpressionContext)staticContext).getStyleElement().allocateSlots(expression);
                --n;
            }
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1 && (this.filters[0] instanceof IntegerValue && ((IntegerValue)this.filters[0]).longValue() == 1L || this.filters[0] instanceof PositionRange && ((PositionRange)this.filters[0]).getMinPosition() == 1 && ((PositionRange)this.filters[0]).getMaxPosition() == 1)) {
            this.firstElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.nodeTest.getPrimitiveType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.isPositional()) {
            this.equivalentExpr = this.makeEquivalentExpression(staticContext);
            this.equivalentExpr = this.equivalentExpr.analyze(staticContext, itemType);
            ((ExpressionContext)staticContext).getStyleElement().allocateSlots(this.equivalentExpr);
            this.specialFilter = true;
        }
        return this;
    }

    private ComputedExpression makeEquivalentExpression(StaticContext staticContext) throws XPathException {
        byte by = this.nodeTest.getPrimitiveType() == 2 ? (byte)2 : 3;
        ComputedExpression computedExpression = new AxisExpression(by, this.nodeTest);
        int n = 0;
        while (n < this.numberOfFilters) {
            computedExpression = new FilterExpression(computedExpression, this.filters[n], staticContext);
            ++n;
        }
        return new PathExpression(new ParentNodeExpression(), computedExpression);
    }

    public boolean matchesX(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        System.err.println("Matching node " + nodeInfo + " against LP pattern " + this);
        System.err.println("Node types " + nodeInfo.getNodeKind() + " / " + this.getNodeKind());
        boolean bl = this.matches(nodeInfo, xPathContext);
        System.err.println(bl ? "matches" : "no match");
        return bl;
    }

    public boolean matches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        return this.internalMatches(nodeInfo, xPathContext);
    }

    protected boolean internalMatches(NodeInfo nodeInfo, XPathContext xPathContext) throws XPathException {
        Object object;
        if (!this.nodeTest.matches(nodeInfo)) {
            return false;
        }
        if (this.parentPattern != null) {
            object = nodeInfo.getParent();
            if (object == null) {
                return false;
            }
            if (!this.parentPattern.internalMatches((NodeInfo)object, xPathContext)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            object = nodeInfo.getParent();
            while (true) {
                if (object == null) {
                    return false;
                }
                if (this.ancestorPattern.internalMatches((NodeInfo)object, xPathContext)) break;
                object = object.getParent();
            }
        }
        if (this.specialFilter) {
            if (this.firstElementPattern) {
                object = nodeInfo.iterateAxis((byte)11, this.nodeTest);
                return object.next() == null;
            }
            if (this.lastElementPattern) {
                object = nodeInfo.iterateAxis((byte)7, this.nodeTest);
                return object.next() == null;
            }
            if (this.equivalentExpr != null) {
                object = xPathContext.newMinorContext();
                object.setOriginatingConstructType(2064);
                object.setCurrentIterator(SingletonIterator.makeIterator(nodeInfo));
                try {
                    NodeInfo nodeInfo2;
                    SequenceIterator sequenceIterator = this.equivalentExpr.iterate((XPathContext)object);
                    do {
                        if ((nodeInfo2 = (NodeInfo)sequenceIterator.next()) != null) continue;
                        return false;
                    } while (!nodeInfo2.isSameNodeInfo(nodeInfo));
                    return true;
                }
                catch (DynamicError dynamicError) {
                    DynamicError dynamicError2 = new DynamicError("An error occurred matching pattern {" + this.toString() + "}: ", dynamicError);
                    dynamicError2.setXPathContext((XPathContext)object);
                    dynamicError2.setErrorCode(dynamicError.getErrorCode());
                    object.getController().recoverableError(dynamicError2);
                    return false;
                }
            }
        }
        if (this.filters != null) {
            object = xPathContext.newMinorContext();
            object.setOriginatingConstructType(2064);
            object.setCurrentIterator(SingletonIterator.makeIterator(nodeInfo));
            int n = 0;
            while (n < this.numberOfFilters) {
                try {
                    if (!this.filters[n].effectiveBooleanValue((XPathContext)object)) {
                        return false;
                    }
                }
                catch (DynamicError dynamicError) {
                    DynamicError dynamicError3 = new DynamicError("An error occurred matching pattern {" + this.toString() + "}: ", dynamicError);
                    dynamicError3.setXPathContext((XPathContext)object);
                    dynamicError3.setErrorCode(dynamicError.getErrorCode());
                    object.getController().recoverableError(dynamicError3);
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    private boolean isPositional() {
        if (this.filters == null) {
            return false;
        }
        int n = 0;
        while (n < this.numberOfFilters) {
            int n2 = this.filters[n].getItemType().getPrimitiveType();
            if (n2 == 517 || n2 == 515 || n2 == 532 || n2 == 516 || n2 == 643) {
                return true;
            }
            if ((this.filters[n].getDependencies() & 0xC) != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

