/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class GlobalVariableDefinition
implements VariableDeclaration {
    private List references = new ArrayList();
    private SequenceType requiredType;
    private Expression value;
    private int nameCode;
    private boolean isParameter;
    private String variableName;
    private int lineNumber;

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
    }

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public void setValueExpression(Expression expression) {
        this.value = expression;
    }

    public void setIsParameter(boolean bl) {
        this.isParameter = bl;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public GeneralVariable compile(StaticQueryContext staticQueryContext, int n) throws XPathException {
        Object object;
        Object object2;
        Object object3;
        GlobalVariable globalVariable;
        if (this.isParameter) {
            globalVariable = new GlobalParam();
            globalVariable.setExecutable(staticQueryContext.getExecutable());
            globalVariable.setRequiredParam(this.value == null);
        } else {
            globalVariable = new GlobalVariable();
            ((GlobalVariable)globalVariable).setExecutable(staticQueryContext.getExecutable());
        }
        if (this.value != null) {
            int n2;
            object3 = new RoleLocator(3, this.variableName, 0);
            object2 = TypeChecker.staticTypeCheck(this.value.simplify(staticQueryContext).analyze(staticQueryContext, Type.ITEM_TYPE), this.requiredType, false, (RoleLocator)object3, staticQueryContext);
            globalVariable.setSelectExpression((Expression)object2);
            if (object2 instanceof ComputedExpression) {
                ((ComputedExpression)object2).setParentExpression(globalVariable);
            }
            if ((n2 = ExpressionTool.allocateSlots((Expression)object2, 0, (SlotManager)(object = staticQueryContext.getConfiguration().makeSlotManager()))) > 0) {
                globalVariable.setContainsLocals((SlotManager)object);
            }
        }
        globalVariable.setNameCode(this.nameCode);
        globalVariable.setRequiredType(this.requiredType);
        if (this.requiredType == SequenceType.ANY_SEQUENCE && !this.isParameter) {
            try {
                object3 = this.value.getItemType();
                int n3 = this.value.getCardinality();
                this.requiredType = new SequenceType((ItemType)object3, n3);
                globalVariable.setRequiredType(this.requiredType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        globalVariable.setVariableName(this.variableName);
        globalVariable.setSlotNumber(n);
        int n4 = ((ComputedExpression)globalVariable).getExecutable().getLocationMap().allocateLocationId(staticQueryContext.getSystemId(), this.lineNumber);
        globalVariable.setLocationId(n4);
        object2 = this.references.iterator();
        while (object2.hasNext()) {
            object = (BindingReference)object2.next();
            object.setStaticType(this.requiredType, null, 0);
            object.fixup(globalVariable);
        }
        return globalVariable;
    }

    public void explain(NamePool namePool) {
        System.err.println("declare variable " + namePool.getDisplayName(this.nameCode) + " := ");
        this.value.display(4, namePool, System.err);
        System.err.println(";");
    }
}

