/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sf.saxon.Loader;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public class CollationFactory {
    public static Collator makeUsingProperties(String string, String string2, String string3) {
        Collator collator = null;
        collator = string != null ? Collator.getInstance(CollationFactory.getLocale(string)) : Collator.getInstance();
        if (string2 != null && collator instanceof Collator) {
            if (string2.equals("primary")) {
                collator.setStrength(0);
            } else if (string2.equals("secondary")) {
                collator.setStrength(1);
            } else if (string2.equals("tertiary")) {
                collator.setStrength(2);
            } else if (string2.equals("identical")) {
                collator.setStrength(3);
            }
        }
        if (string3 != null && collator instanceof Collator) {
            if (string3.equals("none")) {
                collator.setDecomposition(0);
            } else if (string3.equals("standard")) {
                collator.setDecomposition(1);
            } else if (string3.equals("full")) {
                collator.setDecomposition(2);
            }
        }
        return collator;
    }

    private static Locale getLocale(String string) {
        String string2;
        String string3;
        int n = string.indexOf("-");
        if (n < 1) {
            string3 = string;
            string2 = "";
        } else {
            string3 = string.substring(1, n);
            string2 = string.substring(n + 1);
        }
        return new Locale(string3, string2);
    }

    public static Comparator makeComparator(String string) throws XPathException {
        Object object = Loader.getInstance(string);
        if (object instanceof Comparator) {
            return (Comparator)object;
        }
        throw new DynamicError("Failed to load collation class " + string + ": it is not an instance of java.util.Comparator");
    }

    public static Comparator makeCollationFromURI(String string) throws XPathException {
        if (string.equals("http://saxon.sf.net/collation")) {
            return CollationFactory.makeUsingProperties(null, null, null);
        }
        if (string.startsWith("http://saxon.sf.net/collation?")) {
            URI uRI;
            try {
                uRI = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            String string2 = uRI.getQuery();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";&");
            while (stringTokenizer.hasMoreElements()) {
                String string7 = stringTokenizer.nextToken();
                int n = string7.indexOf(61);
                if (n <= 0 || n >= string7.length() - 1) continue;
                String string8 = string7.substring(0, n);
                String string9 = string7.substring(n + 1);
                if (string8.equals("lang")) {
                    string3 = string9;
                    continue;
                }
                if (string8.equals("strength")) {
                    string4 = string9;
                    continue;
                }
                if (string8.equals("decomposition")) {
                    string5 = string9;
                    continue;
                }
                if (!string8.equals("class")) continue;
                string6 = string9;
            }
            if (string6 != null) {
                return CollationFactory.makeComparator(string6);
            }
            return CollationFactory.makeUsingProperties(string3, string4, string5);
        }
        return null;
    }
}

