/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.CopyOf;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.SchemaType;

public final class XSLCopyOf
extends StyleElement {
    private Expression select;
    private boolean copyNamespaces;
    private int validation = 3;
    private SchemaType schemaType;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string5 = this.getNamePool().getClarkName(n2);
            if (string5 == "select") {
                string = attributeCollection.getValue(n);
            } else if (string5 == "copy-namespaces") {
                string2 = attributeCollection.getValue(n).trim();
            } else if (string5 == "validation") {
                string3 = attributeCollection.getValue(n).trim();
            } else if (string5 == "type") {
                string4 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        } else {
            this.reportAbsence("select");
        }
        if (string2 == null) {
            this.copyNamespaces = true;
        } else if (string2.equals("yes")) {
            this.copyNamespaces = true;
        } else if (string2.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'");
        }
        if (string3 != null) {
            this.validation = Validation.getCode(string3);
            if (this.validation != 4 && !this.getConfiguration().isSchemaAware(10)) {
                this.compileError("To perform validation, a schema-aware XSLT processor is needed");
            }
            if (this.validation == -1) {
                this.compileError("invalid value of validation attribute");
            }
        }
        if (string4 != null) {
            this.schemaType = this.getSchemaType(string4);
            if (!this.getConfiguration().isSchemaAware(10)) {
                this.compileError("The type attribute is available only with a schema-aware XSLT processor");
            }
        }
        if (string4 != null && string3 != null) {
            this.compileError("The validation and type attributes are mutually exclusive");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        CopyOf copyOf = new CopyOf(this.select, this.copyNamespaces, this.validation, this.schemaType);
        ExpressionTool.makeParentReferences(copyOf);
        return copyOf;
    }
}

