/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Choose;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class XSLIf
extends StyleElement {
    private Expression test;

    public boolean isInstruction() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string2 = this.getNamePool().getClarkName(n2);
            if (string2 == "test") {
                string = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("test");
        } else {
            this.test = this.makeExpression(string);
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.test = this.typeCheck("test", this.test);
    }

    public void markTailCalls() {
        StyleElement styleElement = this.getLastChildInstruction();
        if (styleElement != null) {
            styleElement.markTailCalls();
        }
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        if (this.test instanceof Value) {
            try {
                if (this.test.effectiveBooleanValue(null)) {
                    Block block = new Block();
                    block.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    this.compileChildren(executable, block, true);
                    return block.simplify(this.getStaticContext());
                }
                return null;
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        Block block = new Block();
        block.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        Expression expression = block;
        Expression[] expressionArray = this.compileChildren(executable, block, true);
        if (expressionArray.length == 1) {
            expression = expressionArray[0];
        }
        Expression[] expressionArray2 = new Expression[]{this.test};
        Expression[] expressionArray3 = new Expression[]{expression};
        Choose choose = new Choose(expressionArray2, expressionArray3);
        ExpressionTool.makeParentReferences(choose);
        return choose;
    }
}

