/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.LocalParam;
import net.sf.saxon.instruct.UserFunctionParameter;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public class XSLParam
extends XSLVariableDeclaration {
    Expression conversion = null;

    protected boolean allowsValue() {
        return !(this.getParentNode() instanceof XSLFunction);
    }

    protected boolean allowsRequired() {
        return !(this.getParentNode() instanceof XSLFunction);
    }

    protected boolean allowsTunnelAttribute() {
        return true;
    }

    public void validate() throws TransformerConfigurationException {
        NodeInfo nodeInfo = (NodeInfo)((Object)this.getParentNode());
        boolean bl = nodeInfo instanceof XSLTemplate || nodeInfo instanceof XSLFunction;
        this.global = nodeInfo instanceof XSLStylesheet;
        if (!bl && !this.global) {
            this.compileError("xsl:param must be immediately within a template, function or stylesheet");
        }
        if (!this.global) {
            NodeInfo nodeInfo2;
            AxisIterator axisIterator = this.iterateAxis((byte)11);
            while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo2 instanceof XSLParam) {
                    if (this.getVariableFingerprint() != ((XSLParam)nodeInfo2).getVariableFingerprint()) continue;
                    this.compileError("The name of the parameter is not unique", "XT0580");
                    continue;
                }
                if (nodeInfo2 instanceof StyleElement) {
                    this.compileError("xsl:param must be the first element within a template or function");
                    continue;
                }
                if (Navigator.isWhite(nodeInfo2.getStringValue())) continue;
                this.compileError("xsl:param must not be preceded by text");
            }
        }
        if (this.requiredParam) {
            if (this.select != null) {
                this.compileError("The select attribute should be omitted when required='yes'");
            }
            if (this.hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content");
            }
        }
        super.validate();
    }

    public Expression compile(Executable executable) throws TransformerConfigurationException {
        ComputedExpression computedExpression;
        if (this.getParent() instanceof XSLFunction) {
            UserFunctionParameter userFunctionParameter = new UserFunctionParameter();
            userFunctionParameter.setRequiredType(this.getRequiredType());
            userFunctionParameter.setSlotNumber(this.getSlotNumber());
            userFunctionParameter.setVariableName(this.getVariableName());
            this.fixupBinding(userFunctionParameter);
            return null;
        }
        int n = this.getSlotNumber();
        if (this.requiredType != null) {
            try {
                computedExpression = new SuppliedParameterReference(n);
                computedExpression.setLocationId(this.staticContext.getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber()));
                this.conversion = TypeChecker.staticTypeCheck(computedExpression, this.requiredType, false, new RoleLocator(3, this.getVariableName(), 0), this.getStaticContext());
            }
            catch (XPathException xPathException) {
                throw new TransformerConfigurationException(xPathException);
            }
        }
        if (this.global) {
            computedExpression = new GlobalParam();
            ((GlobalParam)computedExpression).setExecutable(this.getExecutable());
            if (this.select instanceof ComputedExpression) {
                ((ComputedExpression)this.select).setParentExpression(computedExpression);
            }
        } else {
            computedExpression = new LocalParam();
            ((LocalParam)computedExpression).setConversion(this.conversion);
        }
        this.initializeInstruction(executable, (GeneralVariable)computedExpression);
        ((GeneralVariable)computedExpression).setVariableName(this.getVariableName());
        ((GeneralVariable)computedExpression).setSlotNumber(n);
        ((GeneralVariable)computedExpression).setRequiredType(this.getRequiredType());
        ExpressionTool.makeParentReferences(computedExpression);
        this.fixupBinding((Binding)((Object)computedExpression));
        return computedExpression;
    }

    public SequenceType getRequiredType() {
        if (this.requiredType != null) {
            return this.requiredType;
        }
        return SequenceType.ANY_SEQUENCE;
    }
}

