/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.text.Collator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;

public class KeyDefinition
extends Procedure
implements Serializable,
InstructionInfoProvider {
    private Pattern match;
    private Collator collation;
    private String collationName;

    public KeyDefinition(Pattern pattern, Expression expression, String string, Collator collator) {
        this.match = pattern;
        this.setBody(expression);
        this.collation = collator;
        this.collationName = string;
    }

    public void setStackFrameMap(SlotManager slotManager) {
        if (slotManager != null && slotManager.getNumberOfVariables() > 0) {
            super.setStackFrameMap(slotManager);
        }
    }

    public void setLocation(String string, int n) {
        this.setSystemId(string);
        this.setLineNumber(n);
    }

    public Pattern getMatch() {
        return this.match;
    }

    public Expression getUse() {
        return this.getBody();
    }

    public String getCollationName() {
        return this.collationName;
    }

    public Collator getCollation() {
        return this.collation;
    }

    public InstructionInfo getInstructionInfo() {
        InstructionDetails instructionDetails = new InstructionDetails();
        instructionDetails.setConstructType(154);
        instructionDetails.setSystemId(this.getSystemId());
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setProperty("key", this);
        return instructionDetails;
    }
}

