/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public final class RestrictedStringValue
extends StringValue {
    private int type;

    public RestrictedStringValue(CharSequence charSequence, int n) throws XPathException {
        this.type = n;
        if (charSequence == null) {
            this.value = "";
        } else if (n == 553) {
            this.value = Value.normalizeWhitespace(charSequence);
        } else if (n == 554) {
            this.value = Value.collapseWhitespace(charSequence);
        } else {
            this.value = Value.trimWhitespace(charSequence);
            this.validate();
        }
    }

    private void validate() throws XPathException {
        switch (this.type) {
            case 554: {
                return;
            }
            case 553: {
                return;
            }
            case 555: {
                String string = "(([a-z]|[A-Z])([a-z]|[A-Z])|([iI]-([a-z]|[A-Z])+)|([xX]-([a-z]|[A-Z])+))(-([a-z]|[A-Z])+)*";
                if (!Pattern.matches(string, this.value.toString())) {
                    DynamicError dynamicError = new DynamicError("The value '" + this.value + "' is not a valid xs:language");
                    dynamicError.setErrorCode("FORG0001");
                    throw dynamicError;
                }
                return;
            }
            case 558: {
                StringBuffer stringBuffer = new StringBuffer(this.value.length());
                stringBuffer.append((Object)this.value);
                int n = 0;
                while (n < stringBuffer.length()) {
                    if (stringBuffer.charAt(n) == ':') {
                        stringBuffer.setCharAt(n, '_');
                    }
                    ++n;
                }
                if (!XMLChar.isValidNCName(stringBuffer.toString())) {
                    DynamicError dynamicError = new DynamicError("The value '" + this.value + "' is not a valid Name");
                    dynamicError.setErrorCode("FORG0001");
                    throw dynamicError;
                }
                return;
            }
            case 559: 
            case 560: 
            case 561: 
            case 563: {
                if (!XMLChar.isValidNCName(this.value.toString())) {
                    DynamicError dynamicError = new DynamicError("The value '" + this.value + "' is not a valid NCName");
                    dynamicError.setErrorCode("FORG0001");
                    throw dynamicError;
                }
                return;
            }
            case 556: {
                if (!XMLChar.isValidNmtoken(this.value.toString())) {
                    DynamicError dynamicError = new DynamicError("The value '" + this.value + "' is not a valid NMTOKEN");
                    dynamicError.setErrorCode("FORG0001");
                    throw dynamicError;
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown string value type " + this.type);
    }

    public ItemType getItemType() {
        return (AtomicType)BuiltInSchemaFactory.getSchemaType(this.type);
    }

    public AtomicValue convert(int n, XPathContext xPathContext) throws XPathException {
        if (n == 513) {
            return new StringValue(this.value);
        }
        if (n == 642) {
            return new UntypedAtomicValue(this.value);
        }
        return super.convert(n, xPathContext);
    }

    public String toString() {
        return this.getItemType().toString() + "(" + super.toString() + ")";
    }
}

