/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.JavaExtensionLibrary;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.xpath.StaticError;
import net.sf.saxon.xpath.Variable;
import net.sf.saxon.xpath.XPathException;

public class StandaloneContext
implements StaticContext,
NamespaceResolver {
    private NamePool namePool;
    private HashMap namespaces = new HashMap();
    private HashMap collations = new HashMap();
    private HashMap variables = new HashMap();
    private SlotManager stackFrameMap;
    private String defaultCollationName = null;
    private String baseURI = null;
    private Configuration config;
    private LocationMap locationMap = new LocationMap();
    private FunctionLibrary functionLibrary;
    private String defaultFunctionNamespace = "http://www.w3.org/2004/07/xpath-functions";

    public StandaloneContext() {
        this(new Configuration());
    }

    public StandaloneContext(Configuration configuration) {
        this.config = configuration;
        this.namePool = configuration.getNamePool();
        this.stackFrameMap = configuration.makeSlotManager();
        this.clearNamespaces();
        FunctionLibraryList functionLibraryList = new FunctionLibraryList();
        functionLibraryList.addFunctionLibrary(new SystemFunctionLibrary(this.getConfiguration(), false));
        functionLibraryList.addFunctionLibrary(this.getConfiguration().getVendorFunctionLibrary());
        functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
        if (configuration.isAllowExternalFunctions()) {
            functionLibraryList.addFunctionLibrary(new JavaExtensionLibrary(this.getConfiguration()));
        }
        this.functionLibrary = functionLibraryList;
    }

    public StandaloneContext(NodeInfo nodeInfo) {
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (documentInfo == null) {
            throw new IllegalArgumentException("The node used to establish a standalone context must be in a tree whose root is a document node");
        }
        this.namePool = documentInfo.getNamePool();
        this.setNamespaces(nodeInfo);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        this.namespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("xdt", "http://www.w3.org/2004/07/xpath-datatypes");
        this.declareNamespace("", "");
    }

    public void clearAllNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo nodeInfo) {
        this.namespaces.clear();
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
        NodeInfo nodeInfo2;
        while ((nodeInfo2 = (NodeInfo)axisIterator.next()) != null) {
            this.declareNamespace(nodeInfo2.getLocalPart(), nodeInfo2.getStringValue());
        }
        return;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public void declareCollation(String string, Comparator comparator, boolean bl) {
        this.collations.put(string, comparator);
        if (bl) {
            this.defaultCollationName = string;
        }
    }

    public SlotManager getStackFrameMap() {
        return this.stackFrameMap;
    }

    public Variable declareVariable(String string, Object object) throws XPathException {
        String string2;
        String string3;
        Object object2;
        try {
            object2 = Name.getQNameParts(string);
            string3 = object2[0];
            string2 = object2[1];
        }
        catch (QNameException qNameException) {
            throw new StaticError("Invalid QName for variable: " + string);
        }
        object2 = "";
        if (!"".equals(string3)) {
            object2 = this.getURIForPrefix(string3);
        }
        Variable variable = Variable.make(string);
        variable.setValue(object);
        int n = this.namePool.allocate(string3, (String)object2, string2) & 0xFFFFF;
        this.variables.put(new Integer(n), variable);
        this.stackFrameMap.allocateSlotNumber(n);
        return variable;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string) {
        System.err.println(string);
    }

    public String getSystemId() {
        return "";
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = this.getURIForPrefix(string, false);
        if (string2 == null) {
            throw new StaticError("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public String getURIForPrefix(String string, boolean bl) {
        if (string.equals("") && !bl) {
            return "";
        }
        return (String)this.namespaces.get(string);
    }

    public int getFingerprint(String string, boolean bl, NamePool namePool) throws XPathException {
        return -1;
    }

    public Iterator iteratePrefixes() {
        return null;
    }

    public VariableDeclaration bindVariable(int n) throws StaticError {
        Variable variable = (Variable)this.variables.get(new Integer(n));
        if (variable == null) {
            throw new StaticError("Undeclared variable in a standalone expression");
        }
        return variable;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public void setFunctionLibrary(FunctionLibrary functionLibrary) {
        this.functionLibrary = functionLibrary;
    }

    private FunctionCall bindSystemFunction(String string, Expression[] expressionArray) throws XPathException {
        FunctionCall functionCall = SystemFunction.makeSystemFunction(string, this.namePool);
        if (functionCall == null) {
            throw new StaticError("Unknown system function: " + string);
        }
        if (functionCall instanceof XSLTFunction) {
            throw new StaticError("Function " + string + " is available only in XSLT");
        }
        functionCall.setArguments(expressionArray);
        return functionCall;
    }

    public Comparator getCollation(String string) {
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public short getDefaultElementNamespace() {
        return 0;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.defaultFunctionNamespace = string;
    }

    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    public boolean isImportedSchema(String string) {
        return false;
    }
}

