/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeTextInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.Theme;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;

    Rectangle computeTrim(Theme theme, GC gC) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
    }

    void drawImage(Theme theme, Image image, GC gC, Rectangle rectangle) {
        Image image2 = image;
        Rectangle rectangle2 = image2.getBounds();
        int n = this.state[0];
        if (OS.VERSION >= 4160 && (n & 0x28) != 0) {
            int n2 = 0;
            if ((n & 0x20) != 0) {
                n2 = 1;
            } else if ((n & 8) != 0) {
                n2 = 16384;
            }
            if (n2 != 0) {
                int[] nArray = new int[1];
                OS.HICreateTransformedCGImage(image2.handle, n2, nArray);
                if (nArray[0] != 0) {
                    image2 = Image.carbon_new(null, image2.type, nArray[0], 0);
                }
            }
        }
        gC.drawImage(image2, 0, 0, rectangle2.width, rectangle2.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (image2 != image) {
            image2.dispose();
        }
    }

    void drawText(Theme theme, String string, int n, GC gC, Rectangle rectangle) {
        int n2 = this.state[0];
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        OS.CGContextSaveGState(gC.handle);
        if ((n2 & 0x20) != 0) {
            OS.CGContextSetFillColor(gC.handle, new float[]{0.5f, 0.5f, 0.5f, 1.0f});
        } else if ((n2 & 0x10) != 0) {
            OS.CGContextSetFillColor(gC.handle, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        } else {
            OS.CGContextSetFillColor(gC.handle, new float[]{0.6f, 0.6f, 0.6f, 1.0f});
        }
        CGRect cGRect = new CGRect();
        cGRect.x = rectangle.x;
        cGRect.y = rectangle.y;
        cGRect.width = rectangle.width;
        cGRect.height = rectangle.height;
        HIThemeTextInfo hIThemeTextInfo = this.getTextInfo(n);
        OS.HIThemeDrawTextBox(n3, cGRect, hIThemeTextInfo, gC.handle, 0);
        OS.CGContextRestoreGState(gC.handle);
        OS.CFRelease(n3);
    }

    Rectangle getBounds(int n, Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    int getFontId() {
        return 1;
    }

    HIThemeTextInfo getTextInfo(int n) {
        int n2 = this.state[0];
        HIThemeTextInfo hIThemeTextInfo = new HIThemeTextInfo();
        hIThemeTextInfo.state = (n2 & 8) != 0 ? 2 : ((n2 & 0x10) != 0 ? ((n2 & 0x20) == 0 ? 1 : 7) : ((n2 & 0x20) == 0 ? 0 : 8));
        hIThemeTextInfo.state = hIThemeTextInfo.state;
        hIThemeTextInfo.fontID = (short)this.getFontId();
        if ((n & 0x10) != 0) {
            hIThemeTextInfo.horizontalFlushness = 0;
        }
        if ((n & 0x100) != 0) {
            hIThemeTextInfo.horizontalFlushness = 1;
        }
        if ((n & 0x40) != 0) {
            hIThemeTextInfo.horizontalFlushness = 2;
        }
        if ((n & 0x20) != 0) {
            hIThemeTextInfo.verticalFlushness = 0;
        }
        if ((n & 0x200) != 0) {
            hIThemeTextInfo.verticalFlushness = 1;
        }
        if ((n & 0x80) != 0) {
            hIThemeTextInfo.verticalFlushness = 2;
        }
        hIThemeTextInfo.truncationMaxLines = 0;
        hIThemeTextInfo.truncationPosition = 0;
        hIThemeTextInfo.options = 0;
        return hIThemeTextInfo;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return -1;
    }

    Rectangle measureText(Theme theme, String string, int n, GC gC, Rectangle rectangle) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        int n3 = rectangle != null ? rectangle.width : 0;
        float[] fArray = new float[1];
        float[] fArray2 = new float[1];
        HIThemeTextInfo hIThemeTextInfo = this.getTextInfo(n);
        OS.HIThemeGetTextDimensions(n2, n3, hIThemeTextInfo, fArray, fArray2, null);
        OS.CFRelease(n2);
        return new Rectangle(0, 0, (int)fArray[0], (int)fArray2[0]);
    }
}

