/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.carbon.AlertStdCFStringAlertParamRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";

    public MessageBox(Shell shell) {
        this(shell, 65570);
    }

    public MessageBox(Shell shell, int n) {
        super(shell, MessageBox.checkStyle(n));
        this.checkSubclass();
    }

    static int checkStyle(int n) {
        int n2;
        int n3;
        if ((n & 0x38000) == 0) {
            n |= 0x10000;
        }
        if ((n3 = n & (n2 = 4064)) == 32 || n3 == 256 || n3 == 288) {
            return n;
        }
        if (n3 == 64 || n3 == 128 || n3 == 192 || n3 == 448) {
            return n;
        }
        if (n3 == 1280 || n3 == 3584) {
            return n;
        }
        n = n & ~n2 | 0x20;
        return n;
    }

    int createCFString(String string) {
        String string2 = SWT.getMessage(string);
        char[] cArray = new char[string2.length()];
        string2.getChars(0, cArray.length, cArray, 0);
        return OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        Object object;
        int n = 3;
        if ((this.style & 1) != 0) {
            n = 0;
        }
        if ((this.style & 2) != 0) {
            n = 1;
        }
        if ((this.style & 4) != 0) {
            n = 1;
        }
        if ((this.style & 8) != 0) {
            n = 2;
        }
        if ((this.style & 0x10) != 0) {
            n = 1;
        }
        int n2 = 0;
        int n3 = 0;
        String string = this.title;
        String string2 = this.message;
        if (string != null) {
            object = new char[string.length()];
            string.getChars(0, ((char[])object).length, (char[])object, 0);
            n2 = OS.CFStringCreateWithCharacters(0, object, ((char[])object).length);
        }
        if (string2 != null) {
            object = new char[string2.length()];
            string2.getChars(0, ((char[])object).length, (char[])object, 0);
            n3 = OS.CFStringCreateWithCharacters(0, object, ((char[])object).length);
        }
        object = new AlertStdCFStringAlertParamRec();
        object.version = 1;
        object.position = (short)28682;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 4064;
        int n8 = this.style & n7;
        switch (n8) {
            case 32: {
                object.defaultButton = 1;
                object.defaultText = -1;
                break;
            }
            case 256: {
                object.defaultButton = 1;
                object.defaultText = n4 = this.createCFString("SWT_Cancel");
                break;
            }
            case 288: {
                object.defaultButton = 1;
                object.defaultText = -1;
                object.cancelButton = (short)2;
                object.cancelText = -1;
                break;
            }
            case 64: {
                object.defaultButton = 1;
                object.defaultText = n4 = this.createCFString("SWT_Yes");
                break;
            }
            case 128: {
                object.cancelButton = 1;
                object.cancelText = n4 = this.createCFString("SWT_No");
                break;
            }
            case 192: {
                object.defaultButton = 1;
                object.defaultText = n4 = this.createCFString("SWT_Yes");
                object.cancelButton = (short)2;
                object.cancelText = n5 = this.createCFString("SWT_No");
                break;
            }
            case 448: {
                object.defaultButton = 1;
                object.defaultText = n4 = this.createCFString("SWT_Yes");
                object.otherText = n5 = this.createCFString("SWT_No");
                object.cancelButton = (short)2;
                object.cancelText = -1;
                break;
            }
            case 1280: {
                object.defaultButton = 1;
                object.defaultText = n4 = this.createCFString("SWT_Retry");
                object.cancelButton = (short)2;
                object.cancelText = -1;
                break;
            }
            case 3584: {
                object.defaultButton = 1;
                object.defaultText = n4 = this.createCFString("SWT_Abort");
                object.otherText = n5 = this.createCFString("SWT_Retry");
                object.cancelButton = (short)2;
                object.cancelText = n6 = this.createCFString("SWT_Ignore");
            }
        }
        int[] nArray = new int[1];
        OS.CreateStandardAlert((short)n, n2, n3, (AlertStdCFStringAlertParamRec)object, nArray);
        if (n2 != 0) {
            OS.CFRelease(n2);
        }
        if (n3 != 0) {
            OS.CFRelease(n3);
        }
        if (n4 != 0) {
            OS.CFRelease(n4);
        }
        if (n5 != 0) {
            OS.CFRelease(n5);
        }
        if (n6 != 0) {
            OS.CFRelease(n6);
        }
        if (nArray[0] != 0) {
            if ((this.style & 0x20000) != 0) {
                int[] nArray2 = new int[2];
                nArray2[1] = 2;
                OS.SetFrontProcessWithOptions(nArray2, 1);
            }
            short[] sArray = new short[1];
            OS.RunStandardAlert(nArray[0], 0, sArray);
            if (sArray[0] != 0) {
                switch (n8) {
                    case 32: {
                        return 32;
                    }
                    case 256: {
                        return 256;
                    }
                    case 288: {
                        if (sArray[0] == 1) {
                            return 32;
                        }
                        return 256;
                    }
                    case 64: {
                        return 64;
                    }
                    case 128: {
                        return 128;
                    }
                    case 192: {
                        if (sArray[0] == 1) {
                            return 64;
                        }
                        return 128;
                    }
                    case 448: {
                        if (sArray[0] == 1) {
                            return 64;
                        }
                        if (sArray[0] == 3) {
                            return 128;
                        }
                        return 256;
                    }
                    case 1280: {
                        if (sArray[0] == 1) {
                            return 1024;
                        }
                        return 256;
                    }
                    case 3584: {
                        if (sArray[0] == 1) {
                            return 512;
                        }
                        if (sArray[0] == 3) {
                            return 1024;
                        }
                        return 2048;
                    }
                }
            }
        }
        return 256;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

