/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserCustomCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    GC paintGC;
    int sortDirection;
    int itemCount;
    int columnCount;
    int column_id;
    int idCount;
    int anchorFirst;
    int anchorLast;
    int headerHeight;
    int itemHeight;
    int lastIndexOf;
    boolean ignoreSelect;
    boolean wasSelected;
    boolean fixScrollWidth;
    boolean drawBackground;
    Rectangle imageBounds;
    int showIndex;
    int lastHittest;
    int lastHittestColumn;
    static final int CHECK_COLUMN_ID = 1024;
    static final int COLUMN_ID = 1025;
    static final int GRID_WIDTH = 1;
    static final int ICON_AND_TEXT_GAP = 4;
    static final int CELL_CONTENT_INSET = 12;
    static final int BORDER_INSET = 1;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        int n2 = 0;
        while (n2 < this.items.length) {
            if (this.items[n2] != null) {
                this.items[n2].width = -1;
            }
            ++n2;
        }
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, -1, false);
        return this.items[n];
    }

    int callPaintEventHandler(int n, int n2, int n3, int n4, int n5) {
        GC gC = this.paintGC;
        if (gC == null) {
            GCData gCData = new GCData();
            gCData.paintEvent = n4;
            gCData.visibleRgn = n3;
            this.paintGC = GC.carbon_new(this, gCData);
        }
        this.fixScrollWidth = false;
        this.drawBackground = this.findBackgroundControl() != null;
        int n6 = super.callPaintEventHandler(n, n2, n3, n4, n5);
        if (this.itemCount == 0 && this.drawBackground) {
            this.drawBackground = false;
            Rectangle rectangle = this.getClientArea();
            int n7 = this.getHeaderHeight();
            rectangle.y += n7;
            rectangle.height -= n7;
            this.fillBackground(this.handle, this.paintGC.handle, rectangle);
        }
        if (this.fixScrollWidth) {
            this.fixScrollWidth = false;
            if (this.setScrollWidth(this.items, true)) {
                this.redraw();
            }
        }
        if (gC == null) {
            this.paintGC.dispose();
            this.paintGC = null;
        }
        return n6;
    }

    boolean checkData(TableItem tableItem, boolean bl) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (bl && !this.setScrollWidth(tableItem)) {
                tableItem.redraw(0);
            }
        }
        return true;
    }

    void checkItems(boolean bl) {
        int[] nArray = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, -1, nArray) != 0) {
            this.error(36);
        }
        if (this.itemCount != nArray[0]) {
            DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
            OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
            dataBrowserCallbacks.v1_itemNotificationCallback = 0;
            dataBrowserCallbacks.v1_itemCompareCallback = 0;
            OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
            int n = this.itemCount - nArray[0];
            if (n < 1024) {
                int[] nArray2 = new int[n];
                int n2 = 0;
                while (n2 < nArray2.length) {
                    nArray2[n2] = nArray[0] + n2 + 1;
                    ++n2;
                }
                if (OS.AddDataBrowserItems(this.handle, 0, nArray2.length, nArray2, 0) != 0) {
                    this.error(14);
                }
                OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
            } else if (OS.AddDataBrowserItems(this.handle, 0, this.itemCount, null, 0) != 0) {
                this.error(14);
            }
            dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
            dataBrowserCallbacks.v1_itemCompareCallback = this.itemCompareProc();
            OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        }
        if (bl) {
            this.setScrollWidth(this.items, true);
        }
    }

    static int checkStyle(int n) {
        return Table.checkBits(n |= 0x300, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            if (this.currentItem != tableItem) {
                tableItem.clear();
            }
            if (this.currentItem == null && this.drawCount == 0) {
                int[] nArray = new int[]{n + 1};
                OS.UpdateDataBrowserItems(this.handle, 0, nArray.length, nArray, 0, 0);
            }
            this.setScrollWidth(tableItem);
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            int n3 = n;
            while (n3 <= n2) {
                this.clear(n3);
                ++n3;
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0 || nArray[n] >= this.itemCount) {
                this.error(6);
            }
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            this.clear(nArray[n]);
            ++n;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.itemCount) {
            TableItem tableItem = this.items[n];
            if (tableItem != null) {
                tableItem.clear();
            }
            ++n;
        }
        if (this.currentItem == null && this.drawCount == 0) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        }
        this.setScrollWidth(this.items, true);
    }

    public org.eclipse.swt.graphics.Point computeSize(int n, int n2, boolean bl) {
        Object object;
        int n3;
        this.checkWidget();
        int n4 = 0;
        if (n == -1) {
            if (this.columnCount != 0) {
                n3 = 0;
                while (n3 < this.columnCount) {
                    n4 += this.columns[n3].getWidth();
                    ++n3;
                }
            } else {
                n3 = 0;
                object = new GC(this);
                int n5 = 0;
                while (n5 < this.itemCount) {
                    TableItem tableItem = this.items[n5];
                    if (tableItem != null) {
                        n3 = Math.max(n3, tableItem.calculateWidth(0, (GC)object));
                    }
                    ++n5;
                }
                ((GC)object).dispose();
                n4 += n3 + this.getInsetWidth();
            }
            if ((this.style & 0x20) != 0) {
                n4 += this.getCheckColumnWidth();
            }
        } else {
            n4 = n;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        n3 = 0;
        n3 = n2 == -1 ? this.itemCount * this.getItemHeight() + this.getHeaderHeight() : n2;
        if (n3 <= 0) {
            n3 = 64;
        }
        object = this.computeTrim(0, 0, n4, n3);
        return new org.eclipse.swt.graphics.Point(((Rectangle)object).width, ((Rectangle)object).height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = this.getBorder();
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset(this.handle, rect);
        return new Rectangle(n -= rect.left + n5, n2 -= rect.top + n5, n3 += rect.left + rect.right + n5 + n5, n4 += rect.top + rect.bottom + n5 + n5);
    }

    boolean contains(int n, int n2) {
        CGPoint cGPoint = new CGPoint();
        int[] nArray = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), nArray);
        OS.HIViewConvertPoint(cGPoint, this.handle, nArray[0]);
        int n3 = n - (int)cGPoint.x;
        int n4 = n2 - (int)cGPoint.y;
        if (n4 < this.getHeaderHeight()) {
            return false;
        }
        return this.getClientArea().contains(n3, n4);
    }

    void createHandle() {
        int n;
        DataBrowserListViewColumnDesc dataBrowserListViewColumnDesc;
        this.column_id = 1025;
        int[] nArray = new int[1];
        int n2 = OS.GetControlOwner(this.parent.handle);
        OS.CreateDataBrowserControl(n2, null, 1819505782, nArray);
        OS.SetAutomaticControlDragTrackingEnabledForWindow(n2, true);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData(this.handle, 0, 1651663986, 1, new byte[1]);
        }
        int n3 = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags(this.handle, n3);
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        this.headerHeight = sArray[0];
        OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
        if (OS.VERSION >= 4160) {
            OS.DataBrowserSetMetric(this.handle, 1, false, 4.0f);
        }
        int n4 = 0;
        if ((this.style & 0x20) != 0) {
            dataBrowserListViewColumnDesc = new DataBrowserListViewColumnDesc();
            dataBrowserListViewColumnDesc.headerBtnDesc_version = 0;
            dataBrowserListViewColumnDesc.propertyDesc_propertyID = 1024;
            dataBrowserListViewColumnDesc.propertyDesc_propertyType = 1667785336;
            dataBrowserListViewColumnDesc.propertyDesc_propertyFlags = 1;
            n = this.getCheckColumnWidth();
            dataBrowserListViewColumnDesc.headerBtnDesc_minimumWidth = (short)n;
            dataBrowserListViewColumnDesc.headerBtnDesc_maximumWidth = (short)n;
            dataBrowserListViewColumnDesc.headerBtnDesc_initialOrder = 1;
            OS.AddDataBrowserListViewColumn(this.handle, dataBrowserListViewColumnDesc, n4++);
        }
        dataBrowserListViewColumnDesc = new DataBrowserListViewColumnDesc();
        dataBrowserListViewColumnDesc.headerBtnDesc_version = 0;
        dataBrowserListViewColumnDesc.propertyDesc_propertyID = this.column_id;
        dataBrowserListViewColumnDesc.propertyDesc_propertyType = 0x3F3F3F3F;
        dataBrowserListViewColumnDesc.propertyDesc_propertyFlags = 327680;
        dataBrowserListViewColumnDesc.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        dataBrowserListViewColumnDesc.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn(this.handle, dataBrowserListViewColumnDesc, n4);
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)0);
        OS.HIViewSetDrawingEnabled(this.handle, false);
        n = 50;
        Rect rect = new Rect();
        rect.right = rect.bottom = (short)n;
        OS.SetControlBounds(this.handle, rect);
        int n5 = n * 4;
        int[] nArray2 = new int[1];
        int n6 = OS.NewPtr(n5 * n);
        OS.NewGWorldFromPtr(nArray2, 32, rect, 0, 0, 0, n6, n5);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.GetGWorld(nArray3, nArray4);
        OS.SetGWorld(nArray2[0], nArray4[0]);
        OS.DrawControlInCurrentPort(this.handle);
        OS.SetGWorld(nArray3[0], nArray4[0]);
        OS.DisposeGWorld(nArray2[0]);
        OS.DisposePtr(n6);
        rect.bottom = 0;
        rect.right = 0;
        OS.SetControlBounds(this.handle, rect);
        OS.HIViewSetDrawingEnabled(this.handle, true);
    }

    void createItem(TableColumn tableColumn, int n) {
        String[] stringArray;
        TableColumn[] tableColumnArray;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        tableColumn.id = this.column_id + this.idCount++;
        int n2 = n + ((this.style & 0x20) != 0 ? 1 : 0);
        if (this.columnCount != 0) {
            tableColumnArray = new DataBrowserListViewColumnDesc();
            tableColumnArray.headerBtnDesc_version = 0;
            tableColumnArray.propertyDesc_propertyID = tableColumn.id;
            tableColumnArray.propertyDesc_propertyType = 0x3F3F3F3F;
            tableColumnArray.propertyDesc_propertyFlags = 327680;
            tableColumnArray.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
            tableColumnArray.headerBtnDesc_initialOrder = 1;
            tableColumnArray.headerBtnDesc_btnFontStyle_just = (short)-2;
            if ((this.style & 0x1000000) != 0) {
                tableColumnArray.headerBtnDesc_btnFontStyle_just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                tableColumnArray.headerBtnDesc_btnFontStyle_just = (short)-1;
            }
            tableColumnArray.headerBtnDesc_btnFontStyle_flags = (short)(tableColumnArray.headerBtnDesc_btnFontStyle_flags | 0x40);
            OS.AddDataBrowserListViewColumn(this.handle, (DataBrowserListViewColumnDesc)tableColumnArray, n2);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, tableColumn.id, (short)0);
        }
        if (this.columnCount == this.columns.length) {
            tableColumnArray = new TableColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        if (this.columnCount > 1) {
            int n3 = 0;
            while (n3 < this.itemCount) {
                TableItem tableItem = this.items[n3];
                if (tableItem != null) {
                    Resource[] resourceArray;
                    Color[] colorArray;
                    Resource[] resourceArray2;
                    Object[] objectArray;
                    stringArray = tableItem.strings;
                    if (stringArray != null) {
                        objectArray = new String[this.columnCount];
                        System.arraycopy(stringArray, 0, objectArray, 0, n);
                        System.arraycopy(stringArray, n, objectArray, n + 1, this.columnCount - n - 1);
                        objectArray[n] = "";
                        tableItem.strings = objectArray;
                    }
                    if (n == 0) {
                        tableItem.text = "";
                    }
                    if ((objectArray = tableItem.images) != null) {
                        resourceArray2 = new Image[this.columnCount];
                        System.arraycopy(objectArray, 0, resourceArray2, 0, n);
                        System.arraycopy(objectArray, n, resourceArray2, n + 1, this.columnCount - n - 1);
                        tableItem.images = resourceArray2;
                    }
                    if (n == 0) {
                        tableItem.image = null;
                    }
                    if ((resourceArray2 = tableItem.cellBackground) != null) {
                        colorArray = new Color[this.columnCount];
                        System.arraycopy(resourceArray2, 0, colorArray, 0, n);
                        System.arraycopy(resourceArray2, n, colorArray, n + 1, this.columnCount - n - 1);
                        tableItem.cellBackground = colorArray;
                    }
                    if ((colorArray = tableItem.cellForeground) != null) {
                        resourceArray = new Color[this.columnCount];
                        System.arraycopy(colorArray, 0, resourceArray, 0, n);
                        System.arraycopy(colorArray, n, resourceArray, n + 1, this.columnCount - n - 1);
                        tableItem.cellForeground = resourceArray;
                    }
                    if ((resourceArray = tableItem.cellFont) != null) {
                        Font[] fontArray = new Font[this.columnCount];
                        System.arraycopy(resourceArray, 0, fontArray, 0, n);
                        System.arraycopy(resourceArray, n, fontArray, n + 1, this.columnCount - n - 1);
                        tableItem.cellFont = fontArray;
                    }
                }
                ++n3;
            }
        }
        int[] nArray = new int[1];
        int n4 = 0;
        while (n4 < this.columnCount) {
            stringArray = this.columns[n4];
            OS.GetDataBrowserTableViewColumnPosition(this.handle, stringArray.id, nArray);
            stringArray.lastPosition = nArray[0];
            ++n4;
        }
    }

    void createItem(TableItem tableItem, int n) {
        boolean bl;
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        boolean bl2 = bl = this.drawCount == 0 || n != this.itemCount;
        if (bl) {
            int[] nArray = new int[]{this.itemCount + 1};
            if (OS.AddDataBrowserItems(this.handle, 0, 1, nArray, 0) != 0) {
                this.error(14);
            }
            if (n != this.itemCount) {
                this.fixSelection(n, true);
            }
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.drawCount == 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
        if (bl) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        }
    }

    ScrollBar createScrollBar(int n) {
        return this.createStandardBar(n);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.itemHeight = -1;
        this.showIndex = -1;
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            int[] nArray = new int[]{n + 1};
            this.deselect(nArray, nArray.length);
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n == 0 && n2 == this.itemCount - 1) {
            this.deselectAll();
        } else {
            int n3 = n2 - n + 1;
            if (n3 <= 0) {
                return;
            }
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = n2 - n4 + 1;
                ++n4;
            }
            this.deselect(nArray, n3);
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        int n = nArray.length;
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray[n - n2 - 1] + 1;
            ++n2;
        }
        this.deselect(nArray2, n);
    }

    void deselect(int[] nArray, int n) {
        this.ignoreSelect = true;
        int[] nArray2 = null;
        if ((this.style & 4) != 0) {
            nArray2 = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray2);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, n, nArray, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.deselect(null, 0);
    }

    void destroyItem(TableColumn tableColumn) {
        Object object;
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) break;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.itemCount) {
            object = this.items[n2];
            if (object != null) {
                if (this.columnCount <= 1) {
                    ((TableItem)object).strings = null;
                    ((TableItem)object).images = null;
                    ((TableItem)object).cellBackground = null;
                    ((TableItem)object).cellForeground = null;
                    ((TableItem)object).cellFont = null;
                } else {
                    Object[] objectArray;
                    Object[] objectArray2;
                    if (((TableItem)object).strings != null) {
                        objectArray2 = ((TableItem)object).strings;
                        if (n == 0) {
                            ((TableItem)object).text = objectArray2[1] != null ? objectArray2[1] : "";
                        }
                        objectArray = new String[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).strings = objectArray;
                    } else if (n == 0) {
                        ((TableItem)object).text = "";
                    }
                    if (((TableItem)object).images != null) {
                        objectArray2 = ((TableItem)object).images;
                        if (n == 0) {
                            ((TableItem)object).image = objectArray2[1];
                        }
                        objectArray = new Image[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).images = objectArray;
                    } else if (n == 0) {
                        ((TableItem)object).image = null;
                    }
                    if (((TableItem)object).cellBackground != null) {
                        objectArray2 = ((TableItem)object).cellBackground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).cellBackground = objectArray;
                    }
                    if (((TableItem)object).cellForeground != null) {
                        objectArray2 = ((TableItem)object).cellForeground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).cellForeground = objectArray;
                    }
                    if (((TableItem)object).cellFont != null) {
                        objectArray2 = ((TableItem)object).cellFont;
                        objectArray = new Font[this.columnCount - 1];
                        System.arraycopy(objectArray2, 0, objectArray, 0, n);
                        System.arraycopy(objectArray2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TableItem)object).cellFont = objectArray;
                    }
                }
            }
            ++n2;
        }
        if (this.columnCount == 1) {
            int n3;
            this.column_id = tableColumn.id;
            this.idCount = 0;
            DataBrowserListViewHeaderDesc dataBrowserListViewHeaderDesc = new DataBrowserListViewHeaderDesc();
            dataBrowserListViewHeaderDesc.version = 0;
            object = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short[])object);
            Object object2 = object[0];
            dataBrowserListViewHeaderDesc.maximumWidth = (short)object2;
            dataBrowserListViewHeaderDesc.minimumWidth = (short)object2;
            dataBrowserListViewHeaderDesc.titleString = n3 = OS.CFStringCreateWithCharacters(0, null, 0);
            OS.SetDataBrowserListViewHeaderDesc(this.handle, this.column_id, dataBrowserListViewHeaderDesc);
            OS.CFRelease(n3);
        } else if (OS.RemoveDataBrowserTableViewColumn(this.handle, tableColumn.id) != 0) {
            this.error(15);
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        int n4 = n;
        while (n4 < this.columnCount) {
            this.columns[n4].sendEvent(10);
            ++n4;
        }
    }

    void destroyItem(TableItem tableItem) {
        int[] nArray;
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == tableItem) break;
            ++n;
        }
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        if (OS.RemoveDataBrowserItems(this.handle, 0, (nArray = new int[]{this.itemCount}).length, nArray, 0) != 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        if (this.itemCount == 0) {
            this.setTableEmpty();
        } else {
            this.fixScrollBar();
        }
    }

    int drawItemProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        boolean bl;
        int n8 = n2 - 1;
        if (n8 < 0 || n8 >= this.itemCount) {
            return 0;
        }
        int n9 = 0;
        if (this.columnCount > 0) {
            n9 = 0;
            while (n9 < this.columnCount) {
                if (this.columns[n9].id == n3) break;
                ++n9;
            }
            if (n9 == this.columnCount) {
                return 0;
            }
        }
        Rect rect = new Rect();
        this.lastIndexOf = n8;
        TableItem tableItem = this._getItem(n8);
        if ((this.style & 0x10000000) != 0 && !tableItem.cached) {
            if (!this.checkData(tableItem, false)) {
                return 0;
            }
            if (this.setScrollWidth(tableItem)) {
                if (OS.GetDataBrowserItemPartBounds(this.handle, n2, n3, 0, rect) == 0) {
                    short s = rect.left;
                    short s2 = rect.top;
                    int n10 = rect.right - rect.left;
                    int n11 = rect.bottom - rect.top;
                    this.redrawWidget(this.handle, s, s2, n10, n11, false);
                }
                return 0;
            }
        }
        OS.memmove(rect, n5, 8);
        int n12 = rect.left;
        short s = rect.top;
        int n13 = rect.right - rect.left;
        int n14 = rect.bottom - rect.top;
        GC gC = this.paintGC;
        if (gC == null) {
            GCData gCData = new GCData();
            int[] nArray = new int[1];
            OS.GetPort(nArray);
            gCData.port = nArray[0];
            gC = GC.carbon_new(this, gCData);
        }
        OS.GetDataBrowserItemPartBounds(this.handle, n2, n3, 0, rect);
        short s3 = this.getLinesVisible() ? (short)1 : 0;
        int n15 = rect.left + s3;
        short s4 = rect.top;
        int n16 = rect.right - rect.left - s3;
        int n17 = rect.bottom - rect.top + 1;
        if (this.drawBackground) {
            this.drawBackground = false;
            Region region = new Region(this.display);
            Rectangle rectangle = this.getClientArea();
            int n18 = this.getHeaderHeight();
            rectangle.y += n18;
            rectangle.height -= n18;
            if (rectangle.height < 0) {
                rectangle.height = 0;
            }
            region.add(rectangle);
            if ((this.style & 0x20) != 0 || s3 != 0) {
                int n19 = OS.NewRgn();
                if ((this.style & 0x20) != 0 && OS.GetDataBrowserItemPartBounds(this.handle, n2, 1024, 0, rect) == 0) {
                    OS.SetRectRgn(n19, rect.left, (short)rectangle.y, (short)(rect.right + s3), (short)(rectangle.y + rectangle.height));
                    OS.DiffRgn(region.handle, n19, region.handle);
                }
                if (s3 != 0) {
                    if (this.columnCount == 0) {
                        if (OS.GetDataBrowserItemPartBounds(this.handle, n2, 1025, 0, rect) == 0) {
                            OS.SetRectRgn(n19, rect.right, (short)rectangle.y, (short)(rect.right + s3), (short)(rectangle.y + rectangle.height));
                            OS.DiffRgn(region.handle, n19, region.handle);
                        }
                    } else {
                        int n20 = 0;
                        while (n20 < this.columnCount) {
                            if (OS.GetDataBrowserItemPartBounds(this.handle, n2, this.columns[n20].id, 0, rect) == 0) {
                                OS.SetRectRgn(n19, rect.right, (short)rectangle.y, (short)(rect.right + s3), (short)(rectangle.y + rectangle.height));
                                OS.DiffRgn(region.handle, n19, region.handle);
                            }
                            ++n20;
                        }
                    }
                }
                OS.DisposeRgn(n19);
            }
            if (region != null) {
                gC.setClipping(region);
            }
            this.fillBackground(this.handle, gC.handle, null);
            if (region != null) {
                gC.setClipping((Rectangle)null);
                region.dispose();
            }
        }
        OS.CGContextSaveGState(gC.handle);
        int n21 = OS.NewRgn();
        OS.SetRectRgn(n21, (short)n15, s4, (short)(n15 + n16), (short)(s4 + n17));
        int n22 = OS.NewRgn();
        OS.GetClip(n22);
        OS.SectRgn(n22, n21, n21);
        OS.DisposeRgn(n22);
        Region region = Region.carbon_new(this.display, n21);
        Font font = tableItem.getFont(n9);
        Color color = tableItem.getBackground(n9);
        Color color2 = tableItem.getForeground(n9);
        Image image = tableItem.getImage(n9);
        String string = tableItem.getText(n9);
        gC.setClipping(region);
        gC.setFont(font);
        org.eclipse.swt.graphics.Point point = gC.stringExtent(string);
        int n23 = point.x;
        Rectangle rectangle = null;
        int n24 = 0;
        if (image != null) {
            n24 = this.getGap();
            rectangle = image.getBounds();
            n23 += this.imageBounds.width + n24;
        }
        int n25 = n23;
        if (this.hooks(41)) {
            Event event = new Event();
            event.item = tableItem;
            event.index = n9;
            event.gc = gC;
            event.width = n23;
            event.height = n17;
            this.sendEvent(41, event);
            if (this.itemHeight < event.height) {
                this.itemHeight = event.height;
                OS.SetDataBrowserTableViewRowHeight(this.handle, (short)event.height);
            }
            if (this.setScrollWidth(tableItem)) {
                this.redrawWidget(this.handle, false);
            }
            n23 = event.width;
            n17 = event.height;
            gC.setClipping(region);
            gC.setFont(font);
        }
        int n26 = 16;
        if (tableItem.background != null || tableItem.cellBackground != null && tableItem.cellBackground[n9] != null) {
            n26 |= 8;
        }
        if ((n4 & 5) != 0) {
            n26 |= 2;
        }
        boolean bl2 = bl = (n26 & 2) != 0;
        if ((n26 & 2) != 0 && ((this.style & 0x10000) != 0 || n9 == 0)) {
            gC.setBackground(this.display.getSystemColor(26));
            gC.setForeground(this.display.getSystemColor(27));
        } else {
            gC.setBackground(color);
            gC.setForeground(color2);
        }
        if (this.hooks(40)) {
            object = new Event();
            ((Event)object).item = tableItem;
            ((Event)object).index = n9;
            ((Event)object).gc = gC;
            ((Event)object).x = n15;
            ((Event)object).y = s4;
            ((Event)object).width = n16;
            ((Event)object).height = n17;
            ((Event)object).detail = n26;
            this.sendEvent(40, (Event)object);
            n26 = ((Event)object).doit ? ((Event)object).detail : 0;
            gC.setClipping(region);
            gC.setFont(font);
            if ((n26 & 2) != 0 && ((this.style & 0x10000) != 0 || n9 == 0)) {
                gC.setBackground(this.display.getSystemColor(26));
                gC.setForeground(this.display.getSystemColor(27));
            } else {
                gC.setBackground(color);
                if (!bl) {
                    gC.setForeground(color2);
                }
            }
        }
        if (this.columnCount != 0) {
            object = this.columns[n9];
            if ((((TableColumn)object).style & 0x1000000) != 0) {
                n12 += (n13 - n23) / 2;
            }
            if ((((TableColumn)object).style & 0x20000) != 0) {
                n12 += n13 - n23;
            }
        }
        int n27 = n12;
        if (image != null) {
            n27 += this.imageBounds.width + n24;
        }
        if ((n26 & 2) != 0 && ((this.style & 0x10000) != 0 || n9 == 0)) {
            if ((this.style & 0x8000) == 0 || this.hasFocus()) {
                if ((this.style & 0x10000) != 0) {
                    gC.fillRectangle(n15, s4, n16, n17 - 1);
                    n26 &= 0xFFFFFFF7;
                } else if (n9 == 0) {
                    gC.fillRectangle(n27 - 1, s, point.x + 2, n17 - 1);
                    n26 &= 0xFFFFFFF7;
                }
            } else if ((n26 & 8) != 0) {
                gC.setBackground(color);
            }
        }
        if ((n26 & 8) != 0) {
            if (this.columnCount == 0) {
                gC.fillRectangle(n27 - 1, s, point.x + 2, n17 - 1);
            } else {
                gC.fillRectangle(n15, s4, n16, n17);
            }
        }
        if ((n26 & 0x10) != 0) {
            if (image != null) {
                int n28 = n12;
                int n29 = s + (n14 - this.imageBounds.height) / 2;
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n28, n29, this.imageBounds.width, this.imageBounds.height);
            }
            gC.drawString(string, n27, s + (n14 - point.y) / 2, true);
        }
        if (this.hooks(42)) {
            Event event = new Event();
            event.item = tableItem;
            event.index = n9;
            event.gc = gC;
            event.x = n12;
            event.y = s;
            event.width = n25;
            event.height = n17;
            event.detail = n26;
            this.sendEvent(42, event);
        }
        OS.CGContextRestoreGState(gC.handle);
        OS.DisposeRgn(n21);
        if (gC != this.paintGC) {
            gC.dispose();
        }
        return 0;
    }

    void fixScrollBar() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        int n = Math.max(0, this.getItemHeight() * this.itemCount - this.getClientArea().height);
        if (nArray[0] > n) {
            OS.SetDataBrowserScrollPosition(this.handle, n, nArray2[0]);
        }
    }

    void fixSelection(int n, boolean bl) {
        int[] nArray = this.getSelectionIndices();
        if (nArray.length == 0) {
            return;
        }
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (!bl && nArray[n3] == n) {
                bl2 = true;
            } else {
                int n4 = n2++;
                nArray[n4] = nArray[n3] + 1;
                if (nArray[n4] - 1 >= n) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + (bl ? 1 : -1);
                    bl2 = true;
                }
            }
            ++n3;
        }
        if (bl2) {
            this.select(nArray, n2, true);
        }
    }

    int getBorder() {
        int n = 0;
        byte[] byArray = new byte[1];
        OS.GetControlData(this.handle, (short)0, 1651663986, 1, byArray, null);
        if (byArray[0] != 0) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(7, nArray);
            n += nArray[0] - 1;
        }
        return n;
    }

    int getCheckColumnWidth() {
        Object[] objectArray;
        int n = 0;
        if (OS.VERSION >= 4160) {
            objectArray = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, objectArray);
            n = (int)objectArray[0];
        } else {
            n = 12;
        }
        objectArray = new int[1];
        OS.GetThemeMetric(50, (int[])objectArray);
        return (int)(objectArray[0] + n * 2);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int n = this.getBorder();
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetDataBrowserScrollBarInset(this.handle, rect2);
        int n2 = Math.max(0, rect.right - rect.left - rect2.right - n - n);
        int n3 = Math.max(0, rect.bottom - rect.top - rect2.bottom - n - n);
        return new Rectangle(rect2.left + n, rect2.top + n, n2, n3);
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int[] nArray2 = new int[1];
        int n = 0;
        while (n < this.columnCount) {
            TableColumn tableColumn = this.columns[n];
            OS.GetDataBrowserTableViewColumnPosition(this.handle, tableColumn.id, nArray2);
            if ((this.style & 0x20) != 0) {
                nArray2[0] = nArray2[0] - 1;
            }
            nArray[nArray2[0]] = n++;
        }
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    int getGap() {
        if (OS.VERSION >= 4160) {
            float[] fArray = new float[1];
            OS.DataBrowserGetMetric(this.handle, 2, null, fArray);
            return (int)fArray[0];
        }
        return 4;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        return sArray[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        return sArray[0] != 0;
    }

    int getInsetWidth() {
        if (OS.VERSION >= 4160) {
            float[] fArray = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, fArray);
            return (int)fArray[0] * 2;
        }
        return 24;
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(org.eclipse.swt.graphics.Point point) {
        int n;
        this.checkWidget();
        this.checkItems(true);
        if (point == null) {
            this.error(4);
        }
        Rect rect = new Rect();
        Point point2 = new Point();
        OS.SetPt(point2, (short)point.x, (short)point.y);
        if (this.lastHittest > 0 && this.lastHittest <= this.itemCount && this.lastHittestColumn != 0 && OS.GetDataBrowserItemPartBounds(this.handle, this.lastHittest, this.lastHittestColumn, 0, rect) == 0 && rect.top <= point2.v && point2.v <= rect.bottom) {
            if ((this.style & 0x10000) != 0) {
                return this._getItem(this.lastHittest - 1);
            }
            return OS.PtInRect(point2, rect) ? this._getItem(this.lastHittest - 1) : null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        short[] sArray = new short[1];
        OS.GetDataBrowserTableViewRowHeight(this.handle, sArray);
        short[] sArray2 = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray2);
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = -1;
        int[] nArray4 = nArray3;
        int n2 = 0;
        while (n2 < nArray4.length) {
            n = (nArray[0] - sArray2[0] + point.y) / sArray[0] + nArray4[n2];
            if (n >= 0 && n < this.itemCount) {
                if (this.columnCount == 0) {
                    if (OS.GetDataBrowserItemPartBounds(this.handle, n + 1, this.column_id, 0, rect) == 0 && rect.top <= point2.v && point2.v <= rect.bottom) {
                        if ((this.style & 0x10000) != 0) {
                            return this._getItem(n);
                        }
                        return OS.PtInRect(point2, rect) ? this._getItem(n) : null;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < this.columnCount) {
                        if (OS.GetDataBrowserItemPartBounds(this.handle, n + 1, this.columns[n3].id, 0, rect) == 0 && rect.top <= point2.v && point2.v <= rect.bottom) {
                            if ((this.style & 0x10000) != 0) {
                                return this._getItem(n);
                            }
                            return OS.PtInRect(point2, rect) ? this._getItem(n) : null;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.itemCount) {
            if (this.columnCount == 0) {
                if (OS.GetDataBrowserItemPartBounds(this.handle, n2 + 1, this.column_id, 0, rect) == 0 && rect.top <= point2.v && point2.v <= rect.bottom) {
                    if ((this.style & 0x10000) != 0) {
                        return this._getItem(n2);
                    }
                    return OS.PtInRect(point2, rect) ? this._getItem(n2) : null;
                }
            } else {
                n = 0;
                while (n < this.columnCount) {
                    if (OS.GetDataBrowserItemPartBounds(this.handle, n2 + 1, this.columns[n].id, 0, rect) == 0 && rect.top <= point2.v && point2.v <= rect.bottom) {
                        if ((this.style & 0x10000) != 0) {
                            return this._getItem(n2);
                        }
                        return OS.PtInRect(point2, rect) ? this._getItem(n2) : null;
                    }
                    ++n;
                }
            }
            ++n2;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] sArray = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, sArray) != 0) {
            this.error(11);
        }
        return sArray[0];
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int n = 0;
            while (n < this.itemCount) {
                tableItemArray[n] = this._getItem(n);
                ++n;
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int[] nArray = new int[1];
            OS.DataBrowserGetAttributes(this.handle, nArray);
            return (nArray[0] & 6) != 0;
        }
        return false;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int n = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, n) != 0) {
            this.error(9);
        }
        int n2 = OS.GetHandleSize(n) / 4;
        TableItem[] tableItemArray = new TableItem[n2];
        if (n2 > 0) {
            OS.HLock(n);
            int[] nArray = new int[1];
            OS.memmove(nArray, n, 4);
            int n3 = nArray[0] + (n2 - 1) * 4;
            int n4 = 0;
            while (n4 < n2) {
                OS.memmove(nArray, n3, 4);
                tableItemArray[n4] = this._getItem(nArray[0] - 1);
                ++n4;
                n3 -= 4;
            }
            OS.HUnlock(n);
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] nArray = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, nArray) != 0) {
            this.error(36);
        }
        return nArray[0];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GetDataBrowserSelectionAnchor(this.handle, nArray, nArray2) != 0) {
            return -1;
        }
        return nArray[0] - 1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, n) != 0) {
            this.error(9);
        }
        int n2 = OS.GetHandleSize(n) / 4;
        int[] nArray = new int[n2];
        if (n2 > 0) {
            OS.HLock(n);
            OS.memmove(nArray, n, 4);
            OS.memmove(nArray, nArray[0], n2 * 4);
            OS.HUnlock(n);
            int n3 = 0;
            int n4 = n2 - 1;
            while (n3 <= n4) {
                int n5 = nArray[n3];
                nArray[n3] = nArray[n4] - 1;
                nArray[n4] = n5 - 1;
                ++n3;
                --n4;
            }
        }
        OS.DisposeHandle(n);
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        return nArray[0] / this.getItemHeight();
    }

    /*
     * Unable to fully structure code
     */
    int helpProc(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        block16: {
            if (this.toolTipText != null) break block16;
            switch (var3_3) {
                case 0: {
                    if (this.toolTipText != null && this.toolTipText.length() != 0) break;
                    var6_6 = new Rect();
                    var7_7 = OS.GetControlOwner(this.handle);
                    OS.GetWindowBounds(var7_7, (short)33, var6_6);
                    var8_8 = var6_6.left;
                    var9_9 = var6_6.top;
                    var10_10 = new Point();
                    OS.memmove(var10_10, new int[]{var2_2}, 4);
                    var10_10.h = (short)(var10_10.h - var8_8);
                    var10_10.v = (short)(var10_10.v - var9_9);
                    if (!this.contains(var10_10.h, var10_10.v)) break;
                    var11_11 = null;
                    var12_12 = 23;
                    var13_13 = new CGPoint();
                    var14_14 = new int[1];
                    OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), var14_14);
                    OS.HIViewConvertPoint(var13_13, this.handle, var14_14[0]);
                    var10_10.h = (short)(var10_10.h - (int)var13_13.x);
                    var10_10.v = (short)(var10_10.v - (int)var13_13.y);
                    var8_8 = (short)(var8_8 + (int)var13_13.x);
                    var9_9 = (short)(var9_9 + (int)var13_13.y);
                    var15_15 = var10_10.h;
                    var16_16 = var10_10.v;
                    var17_17 = this.getHeaderHeight();
                    if (var17_17 == 0 || var16_16 < 0 || var16_16 >= var17_17) ** GOTO lbl47
                    var18_18 = 0;
                    var19_20 = 0;
                    while (var19_20 < this.columnCount) {
                        var20_23 = this.columns[var19_20];
                        var21_24 = var20_23.lastWidth;
                        if (var18_18 > var15_15 || var15_15 >= var18_18 + var21_24) ** GOTO lbl43
                        var11_11 = var20_23.toolTipText;
                        var6_6.left = (short)var18_18;
                        var6_6.right = (short)(var6_6.left + var21_24);
                        var6_6.bottom = (short)(var6_6.top + var17_17);
                        var12_12 = 10;
                        ** GOTO lbl91
lbl43:
                        // 1 sources

                        var18_18 += var21_24;
                        ++var19_20;
                    }
                    ** GOTO lbl91
lbl47:
                    // 1 sources

                    var18_18 = 0;
                    var19_21 = null;
                    var20_23 = null;
                    var21_25 = 0;
                    var22_26 = this.getTopIndex();
                    while (var22_26 < this.itemCount && var19_21 == null && var21_25 == 0) {
                        if (this.columnCount == 0) {
                            var21_25 = OS.GetDataBrowserItemPartBounds(this.handle, var22_26 + 1, this.column_id, 0x2D2D2D2D, var6_6);
                            if (var21_25 == 0 && OS.PtInRect(var10_10, var6_6)) {
                                var19_21 = this._getItem(var22_26);
                                break;
                            }
                        } else {
                            var23_28 = 0;
                            while (var23_28 < this.columnCount) {
                                var20_23 = this.columns[var23_28];
                                var21_25 = OS.GetDataBrowserItemPartBounds(this.handle, var22_26 + 1, var20_23.id, 0x2D2D2D2D, var6_6);
                                if (var21_25 == 0 && OS.PtInRect(var10_10, var6_6)) {
                                    var19_21 = this._getItem(var22_26);
                                    var18_18 = var23_28;
                                    break;
                                }
                                ++var23_28;
                            }
                        }
                        ++var22_26;
                    }
                    if (var19_21 != null) {
                        var22_27 = new GC(this);
                        var23_28 = this.getInsetWidth();
                        var24_29 = var19_21.calculateWidth(var18_18, var22_27) + var23_28;
                        var22_27.dispose();
                        var25_30 = new short[1];
                        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, var20_23 == null ? this.column_id : var20_23.id, var25_30);
                        if (var24_29 > var25_30[0]) {
                            var11_11 = var19_21.getText(var18_18);
                            var26_31 = var19_21.getImage(var18_18);
                            var27_32 = var26_31 != null ? var26_31.getBounds().width + this.getGap() : 0;
                            v0 = var28_33 = var20_23 == null ? 16384 : var20_23.style;
                            if ((var28_33 & 16384) != 0) {
                                var6_6.left = (short)(var6_6.left + var27_32);
                                var6_6.right = (short)(var6_6.left + var24_29 - var27_32 - var23_28);
                            }
                            if ((var28_33 & 131072) != 0) {
                                var6_6.left = (short)(var6_6.right - var24_29 + var27_32 + var23_28);
                            }
                            if ((var28_33 & 0x1000000) != 0) {
                                var6_6.left = (short)(var6_6.left + var27_32);
                            }
                        }
                    }
lbl91:
                    // 9 sources

                    if (var11_11 == null || var11_11.length() == 0) break;
                    var18_19 = new char[var11_11.length()];
                    var11_11.getChars(0, var18_19.length, var18_19, 0);
                    var19_22 = this.fixMnemonic(var18_19);
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters(0, var18_19, var19_22);
                    var20_23 = new HMHelpContentRec();
                    OS.memmove((HMHelpContentRec)var20_23, var5_5, 534);
                    this.display.helpWidget = this;
                    var20_23.version = 3;
                    var20_23.tagSide = (short)var12_12;
                    var20_23.absHotRect_left = (short)(var6_6.left + var8_8);
                    var20_23.absHotRect_top = (short)(var6_6.top + var9_9);
                    var20_23.absHotRect_right = (short)(var6_6.right + var8_8);
                    var20_23.absHotRect_bottom = (short)(var6_6.bottom + var9_9);
                    var20_23.content0_contentType = 1667658612;
                    var20_23.content0_tagCFString = this.display.helpString;
                    var20_23.content1_contentType = 1667658612;
                    var20_23.content1_tagCFString = this.display.helpString;
                    OS.memmove(var5_5, (HMHelpContentRec)var20_23, 534);
                    OS.memmove(var4_4, new short[1], 2);
                    return 0;
                }
            }
        }
        return super.helpProc(var1_1, var2_2, var3_3, var4_4, var5_5);
    }

    int hitTestProc(int n, int n2, int n3, int n4, int n5) {
        this.lastHittest = n2;
        this.lastHittestColumn = n3;
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        dataBrowserCallbacks.version = 0;
        OS.InitDataBrowserCallbacks(dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemDataCallback = this.display.itemDataProc;
        dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        dataBrowserCallbacks.v1_itemCompareCallback = this.itemCompareProc();
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        DataBrowserCustomCallbacks dataBrowserCustomCallbacks = new DataBrowserCustomCallbacks();
        dataBrowserCustomCallbacks.version = 0;
        OS.InitDataBrowserCustomCallbacks(dataBrowserCustomCallbacks);
        dataBrowserCustomCallbacks.v1_drawItemCallback = this.display.drawItemProc;
        dataBrowserCustomCallbacks.v1_hitTestCallback = this.display.hitTestProc;
        dataBrowserCustomCallbacks.v1_trackingCallback = this.display.trackingProc;
        OS.SetDataBrowserCustomCallbacks(this.handle, dataBrowserCustomCallbacks);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int n = 0;
            while (n < this.itemCount) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                ++n;
            }
        } else {
            int n = this.itemCount - 1;
            while (n >= 0) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                --n;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        return OS.IsDataBrowserItemSelected(this.handle, n + 1);
    }

    int itemCompareProc() {
        return this.sortDirection == 1024 && this.sortColumn != null ? this.display.itemCompareProc : 0;
    }

    int itemCompareProc(int n, int n2, int n3, int n4) {
        if (this.sortDirection == 1024 && this.sortColumn != null) {
            return n2 > n3 ? 1 : 0;
        }
        return n2 < n3 ? 1 : 0;
    }

    int itemDataProc(int n, int n2, int n3, int n4, int n5) {
        int n6 = n2 - 1;
        if (n6 < 0 || n6 >= this.items.length) {
            return 0;
        }
        switch (n3) {
            case 1024: {
                TableItem tableItem = this._getItem(n6);
                if (!this.checkData(tableItem, false)) {
                    return 0;
                }
                if (n5 != 0) {
                    boolean bl = tableItem.checked = !tableItem.checked;
                    if (tableItem.checked && tableItem.grayed) {
                        OS.SetDataBrowserItemDataButtonValue(n4, (short)2);
                    } else {
                        boolean bl2 = tableItem.checked;
                        OS.SetDataBrowserItemDataButtonValue(n4, (short)(bl2 ? 1 : 0));
                    }
                    Event event = new Event();
                    event.item = tableItem;
                    event.detail = 32;
                    this.postEvent(13, event);
                    if (tableItem.checked) break;
                    tableItem.redraw(1024);
                    break;
                }
                int n7 = 0;
                if (tableItem.checked) {
                    n7 = tableItem.grayed ? 2 : 1;
                }
                OS.SetDataBrowserItemDataButtonValue(n4, (short)n7);
            }
        }
        return 0;
    }

    int itemNotificationProc(int n, int n2, int n3) {
        if (n3 == 13) {
            boolean bl = false;
            short[] sArray = new short[1];
            int[] nArray = new int[1];
            TableColumn[] tableColumnArray = this.getColumns();
            int n4 = 0;
            while (n4 < this.columnCount) {
                TableColumn tableColumn = tableColumnArray[n4];
                if (!tableColumn.isDisposed()) {
                    OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, tableColumn.id, sArray);
                    if (sArray[0] != tableColumn.lastWidth) {
                        tableColumn.resized(sArray[0]);
                        bl = true;
                    }
                }
                if (!tableColumn.isDisposed()) {
                    OS.GetDataBrowserTableViewColumnPosition(this.handle, tableColumn.id, nArray);
                    if (nArray[0] != tableColumn.lastPosition) {
                        tableColumn.lastPosition = nArray[0];
                        tableColumn.sendEvent(10);
                        bl = true;
                    }
                }
                ++n4;
            }
            int[] nArray2 = new int[1];
            OS.GetDataBrowserSortProperty(this.handle, nArray2);
            if (nArray2[0] != 0) {
                if (!bl) {
                    int n5 = 0;
                    while (n5 < this.columnCount) {
                        TableColumn tableColumn = tableColumnArray[n5];
                        if (nArray2[0] == tableColumn.id) {
                            tableColumn.postEvent(this.display.clickCount == 2 ? 14 : 13);
                            break;
                        }
                        ++n5;
                    }
                }
                OS.SetDataBrowserSortProperty(this.handle, 0);
                if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
                    OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
                    int n6 = this.sortDirection == 1024 ? 2 : 1;
                    OS.SetDataBrowserSortOrder(this.handle, (short)n6);
                }
            }
            return 0;
        }
        int n7 = n2 - 1;
        if (n7 < 0 || n7 >= this.items.length) {
            return 0;
        }
        switch (n3) {
            case 5: 
            case 6: {
                TableItem tableItem = this._getItem(n7);
                this.wasSelected = true;
                if (this.ignoreSelect) break;
                int[] nArray = new int[1];
                int[] nArray3 = new int[1];
                OS.GetDataBrowserSelectionAnchor(this.handle, nArray, nArray3);
                boolean bl = false;
                if ((this.style & 2) != 0) {
                    int n8 = OS.GetCurrentEventKeyModifiers();
                    bl = (n8 & 0x200) != 0 ? (n3 == 5 ? nArray[0] == n2 || nArray3[0] == n2 : n2 == this.anchorFirst || n2 == this.anchorLast) : ((n8 & 0x100) != 0 ? true : nArray[0] == nArray3[0]);
                } else {
                    boolean bl2 = bl = n3 == 5;
                }
                if (!bl) break;
                this.anchorFirst = nArray[0];
                this.anchorLast = nArray3[0];
                Event event = new Event();
                event.item = tableItem;
                this.postEvent(13, event);
                break;
            }
            case 7: {
                this.wasSelected = true;
                if (this.display.clickCount != 2) break;
                Event event = new Event();
                event.item = this._getItem(n7);
                this.postEvent(14, event);
            }
        }
        return 0;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4;
        int n5 = super.kEventMouseDown(n, n2, n3);
        if (n5 == 0) {
            return n5;
        }
        this.wasSelected = false;
        n5 = OS.CallNextEventHandler(n, n2);
        if (this.isDisposed()) {
            return 0;
        }
        if (!this.wasSelected && OS.IsDataBrowserItemSelected(this.handle, this.lastHittest) && (n4 = this.lastHittest - 1) >= 0 && n4 < this.itemCount) {
            Event event = new Event();
            event.item = this._getItem(n4);
            this.postEvent(13, event);
        }
        return n5;
    }

    int kEventControlGetClickActivation(int n, int n2, int n3) {
        OS.SetEventParameter(n2, 1668047203, 1668047203, 4, new int[]{3});
        return 0;
    }

    int kEventControlSetCursor(int n, int n2, int n3) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        if (this.isEnabledModal()) {
            Point point = new Point();
            int n4 = 4;
            OS.GetEventParameter(n2, 1835822947, 1363439732, null, n4, null, point);
            if (!this.contains(point.h, point.v)) {
                return -9874;
            }
        }
        return super.kEventControlSetCursor(n, n2, n3);
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        switch (nArray2[0]) {
            case 36: 
            case 76: {
                this.postEvent(14);
                break;
            }
            case 125: {
                int n5 = this.getSelectionIndex();
                this.setSelection(Math.min(this.itemCount - 1, n5 + 1), true);
                return 0;
            }
            case 126: {
                int n6 = this.getSelectionIndex();
                this.setSelection(Math.max(0, n6 - 1), true);
                return 0;
            }
        }
        return n4;
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            n = 0;
            while (n < this.itemCount) {
                item = this.items[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                item = this.columns[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.currentItem = null;
        this.sortColumn = null;
        this.paintGC = null;
        this.imageBounds = null;
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemNotificationCallback = 0;
        dataBrowserCallbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
    }

    public void remove(int n) {
        int[] nArray;
        TableItem tableItem;
        this.checkWidget();
        this.checkItems(true);
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.release(false);
        }
        if (n != this.itemCount - 1) {
            this.fixSelection(n, false);
        }
        if (OS.RemoveDataBrowserItems(this.handle, 0, (nArray = new int[]{this.itemCount}).length, nArray, 0) != 0) {
            this.error(15);
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        if (this.itemCount == 0) {
            this.setTableEmpty();
        } else {
            this.fixScrollBar();
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.removeAll();
        } else {
            int n3 = n2 - n + 1;
            int n4 = 0;
            while (n4 < n3) {
                this.remove(n);
                ++n4;
            }
        }
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < nArray2.length) {
            int n5 = nArray2[n4];
            if (n5 != n3) {
                this.remove(n5);
                n3 = n5;
            }
            ++n4;
        }
    }

    public void removeAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.itemCount) {
            TableItem tableItem = this.items[n];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            ++n;
        }
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemNotificationCallback = 0;
        dataBrowserCallbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        dataBrowserCallbacks.v1_itemCompareCallback = this.itemCompareProc();
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        this.setTableEmpty();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resetVisibleRegion(int n) {
        super.resetVisibleRegion(n);
        if (this.showIndex != -1) {
            this.showIndex(this.showIndex);
        }
    }

    public void select(int n) {
        this.checkWidget();
        this.checkItems(false);
        if (n >= 0 && n < this.itemCount) {
            int[] nArray = new int[]{n + 1};
            this.select(nArray, nArray.length, false);
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        this.checkItems(false);
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.selectAll();
        } else {
            n = Math.max(0, n);
            n2 = Math.min(n2, this.itemCount - 1);
            int n3 = n2 - n + 1;
            int[] nArray = new int[n3];
            int n4 = 0;
            while (n4 < n3) {
                nArray[n4] = n2 - n4 + 1;
                ++n4;
            }
            this.select(nArray, n3, false);
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        this.checkItems(false);
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n - n3 - 1];
            if (n4 >= 0 && n4 < this.itemCount) {
                nArray2[n2++] = n4 + 1;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.select(nArray2, n2, false);
        }
    }

    void select(int[] nArray, int n, boolean bl) {
        this.ignoreSelect = true;
        int[] nArray2 = null;
        if ((this.style & 4) != 0) {
            nArray2 = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray2);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0] & 0xFFFFFFBF);
        }
        int n2 = 1;
        if ((this.style & 2) != 0 && !bl) {
            n2 = 0;
        }
        OS.SetDataBrowserSelectedItems(this.handle, n, nArray, n2);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0]);
        }
        this.ignoreSelect = false;
    }

    public void selectAll() {
        this.checkWidget();
        this.checkItems(false);
        if ((this.style & 4) != 0) {
            return;
        }
        this.select(null, 0, false);
    }

    void setBackground(float[] fArray) {
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if (this.showIndex != -1) {
            this.showIndex(this.showIndex);
        }
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            if (nArray[n] != nArray2[n]) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            TableColumn tableColumn;
            int n3;
            n = 0;
            short[] sArray = new short[1];
            int[] nArray3 = new int[nArray2.length];
            int n4 = 0;
            while (n4 < nArray2.length) {
                n3 = nArray2[n4];
                TableColumn tableColumn2 = this.columns[n3];
                nArray3[n3] = n;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, tableColumn2.id, sArray);
                n += sArray[0];
                ++n4;
            }
            n = 0;
            int[] nArray4 = new int[nArray.length];
            n3 = 0;
            while (n3 < nArray.length) {
                int n5 = nArray[n3];
                tableColumn = this.columns[n5];
                int n6 = (this.style & 0x20) != 0 ? n3 + 1 : n3;
                OS.SetDataBrowserTableViewColumnPosition(this.handle, tableColumn.id, n6);
                tableColumn.lastPosition = n6;
                nArray4[n5] = n;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, tableColumn.id, sArray);
                n += sArray[0];
                ++n3;
            }
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
            int n7 = 0;
            while (n7 < this.columnCount) {
                tableColumn = tableColumnArray[n7];
                if (!tableColumn.isDisposed() && nArray4[n7] != nArray3[n7]) {
                    tableColumn.sendEvent(10);
                }
                ++n7;
            }
        }
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int n = 0;
        while (n < this.items.length) {
            TableItem tableItem = this.items[n];
            if (tableItem != null) {
                tableItem.width = -1;
            }
            ++n;
        }
        this.setScrollWidth(this.items, true);
        this.setItemHeight(null);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        if (sArray[0] != 0 != bl) {
            OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)(bl ? this.headerHeight : 0));
            this.invalidateVisibleRegion(this.handle);
        }
    }

    public void setItemCount(int n) {
        Object[] objectArray;
        int n2;
        this.checkWidget();
        this.checkItems(true);
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        this.setRedraw(false);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemNotificationCallback = 0;
        dataBrowserCallbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        if (n < this.itemCount) {
            Object object;
            n2 = n;
            objectArray = new int[this.itemCount - n];
            while (n2 < this.itemCount) {
                object = this.items[n2];
                if (object != null) {
                    ((Widget)object).release(false);
                }
                objectArray[n2 - n] = n2 + 1;
                ++n2;
            }
            OS.RemoveDataBrowserItems(this.handle, 0, objectArray.length, objectArray, 0);
            object = new int[1];
            if (OS.GetDataBrowserItemCount(this.handle, 0, true, -1, (int[])object) != 0) {
                this.error(36);
            }
            if (n != object[0]) {
                this.error(15);
            }
        }
        n2 = Math.max(4, (n + 3) / 4 * 4);
        objectArray = new TableItem[n2];
        System.arraycopy(this.items, 0, objectArray, 0, Math.min(n, this.itemCount));
        this.items = (TableItem[])objectArray;
        if ((this.style & 0x10000000) == 0) {
            int n3 = this.itemCount;
            while (n3 < n) {
                this.items[n3] = new TableItem(this, 0, n3, false);
                ++n3;
            }
        }
        this.itemCount = n;
        OS.AddDataBrowserItems(this.handle, 0, this.itemCount, null, 0);
        dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        dataBrowserCallbacks.v1_itemCompareCallback = this.itemCompareProc();
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        this.fixScrollBar();
        this.setRedraw(true);
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        if (n != -1) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)n);
        }
    }

    void setItemHeight(Image image) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle == null) {
            return;
        }
        this.imageBounds = rectangle;
        short[] sArray = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, sArray) == 0 && sArray[0] < rectangle.height) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)rectangle.height);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int n = 6;
            OS.DataBrowserChangeAttributes(this.handle, bl ? n : 0, !bl ? n : 0);
            this.redraw();
        }
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            if (this.items.length > 4 && this.items.length - this.itemCount > 3) {
                int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
                TableItem[] tableItemArray = new TableItem[n];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
                this.items = tableItemArray;
            }
            this.checkItems(true);
        }
    }

    boolean setScrollWidth(TableItem tableItem) {
        if (this.columnCount != 0) {
            return false;
        }
        if (this.currentItem != null) {
            if (this.currentItem != tableItem) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (this.drawCount != 0) {
            return false;
        }
        GC gC = new GC(this);
        int n = tableItem.calculateWidth(0, gC);
        gC.dispose();
        short[] sArray = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, sArray);
        if (sArray[0] < (n += this.getInsetWidth())) {
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)n);
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TableItem[] tableItemArray, boolean bl) {
        if (this.columnCount != 0) {
            return false;
        }
        if (this.currentItem != null) {
            this.fixScrollWidth = true;
            return false;
        }
        if (this.drawCount != 0) {
            return false;
        }
        GC gC = new GC(this);
        short s = 0;
        int n = 0;
        while (n < tableItemArray.length) {
            TableItem tableItem = tableItemArray[n];
            if (tableItem != null) {
                s = Math.max(s, tableItem.calculateWidth(0, gC));
            }
            ++n;
        }
        gC.dispose();
        s += this.getInsetWidth();
        if (!bl) {
            short[] sArray = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, sArray);
            if (sArray[0] >= s) {
                return false;
            }
        }
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, s);
        return true;
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.checkItems(false);
        this.deselectAll();
        this.setSelection(n, false);
    }

    void setSelection(int n, boolean bl) {
        if (n >= 0 && n < this.itemCount) {
            int[] nArray = new int[]{n + 1};
            this.select(nArray, nArray.length, true);
            this.showIndex(n);
            if (bl) {
                Event event = new Event();
                event.item = this._getItem(n);
                this.postEvent(13, event);
            }
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.checkItems(false);
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        int n3 = n2 - n + 1;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n2 - n4 + 1;
            ++n4;
        }
        this.select(nArray, n3, true);
        this.showIndex(nArray[0] - 1);
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        this.checkItems(false);
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n - n3 - 1];
            if (n4 >= 0 && n4 < this.itemCount) {
                nArray2[n2++] = n4 + 1;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.select(nArray2, n2, true);
            this.showIndex(nArray2[0] - 1);
        }
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        this.checkItems(false);
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = tableItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.indexOf(tableItemArray[n - n3 - 1]);
            if (n4 != -1) {
                nArray[n2++] = n4 + 1;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.select(nArray, n2, true);
            this.showIndex(nArray[0] - 1);
        }
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn == this.sortColumn) {
            return;
        }
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        if (tableColumn == null && this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            OS.SetDataBrowserSortOrder(this.handle, (short)1);
            this.sortColumn = null;
            OS.SetDataBrowserSortProperty(this.handle, 0);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
            int n = this.sortDirection == 1024 ? 2 : 1;
            OS.SetDataBrowserSortOrder(this.handle, (short)n);
        }
        dataBrowserCallbacks.v1_itemCompareCallback = this.itemCompareProc();
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        if (n == this.sortDirection) {
            return;
        }
        this.sortDirection = n;
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            if (this.sortDirection == 0) {
                OS.SetDataBrowserSortOrder(this.handle, (short)1);
                TableColumn tableColumn = this.sortColumn;
                this.sortColumn = null;
                OS.SetDataBrowserSortProperty(this.handle, 0);
                this.sortColumn = tableColumn;
            } else {
                OS.SetDataBrowserSortProperty(this.handle, 0);
                OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
                int n2 = this.sortDirection == 1024 ? 2 : 1;
                OS.SetDataBrowserSortOrder(this.handle, (short)n2);
            }
        }
        dataBrowserCallbacks.v1_itemCompareCallback = this.itemCompareProc();
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
    }

    void setTableEmpty() {
        this.itemHeight = -1;
        OS.SetDataBrowserScrollPosition(this.handle, 0, 0);
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.itemCount = 0;
        this.items = new TableItem[4];
        if (this.imageBounds != null) {
            this.imageBounds = null;
            this.setFontStyle(this.font);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        this.checkItems(false);
        int n2 = this.getItemHeight();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        nArray[0] = Math.max(0, Math.min(n2 * this.itemCount - this.getClientArea().height, n * n2));
        OS.SetDataBrowserScrollPosition(this.handle, nArray[0], nArray2[0]);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        int n = this.indexOf(tableColumn);
        if (this.columnCount <= 1 || n < 0 || n >= this.columnCount) {
            return;
        }
        short[] sArray = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, tableColumn.id, sArray);
        int n2 = sArray[0];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            sArray = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.columns[n4].id, sArray);
            n3 += sArray[0];
            ++n4;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        if (n3 < nArray2[0]) {
            OS.SetDataBrowserScrollPosition(this.handle, nArray[0], n3);
        } else {
            Rectangle rectangle = this.getClientArea();
            int n5 = rectangle.width;
            if (n3 + (n2 = Math.min(n2, n5)) > nArray2[0] + n5) {
                nArray2[0] = n3 + n2 - n5;
                OS.SetDataBrowserScrollPosition(this.handle, nArray[0], nArray2[0]);
            }
        }
    }

    void showIndex(int n) {
        if (n >= 0 && n < this.itemCount) {
            Rectangle rectangle = this.getClientArea();
            if (rectangle.height < this.getItemHeight() || !OS.IsControlVisible(this.handle)) {
                this.showIndex = n;
                return;
            }
            this.showIndex = -1;
            TableItem tableItem = this._getItem(n);
            Rectangle rectangle2 = tableItem.getBounds(0);
            if (!rectangle2.isEmpty() && rectangle.contains(rectangle2.x, rectangle2.y) && rectangle.contains(rectangle2.x, rectangle2.y + rectangle2.height)) {
                return;
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
            OS.RevealDataBrowserItem(this.handle, n + 1, 0, (byte)2);
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, nArray3, nArray4);
            if (this.horizontalBar != null && nArray4[0] != nArray2[0]) {
                this.horizontalBar.redraw();
            }
            if (this.verticalBar != null && nArray3[0] != nArray[0]) {
                this.verticalBar.redraw();
            }
        }
    }

    public void showItem(TableItem tableItem) {
        int n;
        this.checkWidget();
        this.checkItems(false);
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n = this.indexOf(tableItem)) != -1) {
            this.showIndex(n);
        }
    }

    public void showSelection() {
        this.checkWidget();
        this.checkItems(false);
        int n = this.getSelectionIndex();
        if (n >= 0) {
            this.showIndex(n);
        }
    }

    int trackingProc(int n, int n2, int n3, int n4, int n5, int n6) {
        return 1;
    }
}

