/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBar
extends Composite {
    int itemCount;
    ToolItem[] items;

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n;
        int n4 = n2;
        if (n == -1) {
            n3 = Integer.MAX_VALUE;
        }
        if (n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        int[] nArray = this.layout(n3, n4, false);
        Point point = new Point(nArray[1], nArray[2]);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    void createHandle() {
        this.state |= 0x820;
        super.createHandle(this.parent.handle);
    }

    void createItem(ToolItem toolItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        toolItem.createWidget();
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = toolItem;
        this.relayout();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 108;
        }
        return 0;
    }

    void destroyItem(ToolItem toolItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        this.relayout();
    }

    void drawBackground(int n, int n2) {
        this.fillBackground(n, n2, null);
    }

    void enableWidget(boolean bl) {
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            return this.items[n];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            Rectangle rectangle = this.items[n].getBounds();
            if (rectangle.contains(point)) {
                return this.items[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] toolItemArray = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, toolItemArray, 0, this.itemCount);
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        return this.layout(rectangle.width, rectangle.height, false)[0];
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void invalidateChildrenVisibleRegion(int n) {
        super.invalidateChildrenVisibleRegion(n);
        int n2 = 0;
        while (n2 < this.itemCount) {
            ToolItem toolItem = this.items[n2];
            toolItem.resetVisibleRegion(n);
            ++n2;
        }
    }

    int[] layoutHorizontal(int n, int n2, boolean bl) {
        Object object;
        int n3 = 0;
        int n4 = 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize();
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).y);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n7 + point.x > n) {
                ++n10;
                n7 = n5;
                n8 += n4 + n11;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, point.x, n11);
                boolean bl3 = n7 + point.x <= n && n8 + n11 <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    int n13 = n8 + (n11 - point.y) / 2;
                    control.setBounds(n7, n13, point.x, n11 - (n13 - n8));
                }
            }
            n9 = Math.max(n9, n7 += n3 + point.x);
            ++n12;
        }
        if (bl) {
            this.invalidateVisibleRegion(this.handle);
        }
        return new int[]{n10, n9, n8 + n11};
    }

    int[] layoutVertical(int n, int n2, boolean bl) {
        Object object;
        int n3 = 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize();
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).x);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n8 + point.y > n2) {
                ++n10;
                n7 += n3 + n11;
                n8 = n6;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, n11, point.y);
                boolean bl3 = n7 + n11 <= n && n8 + point.y <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    int n13 = n7 + (n11 - point.x) / 2;
                    control.setBounds(n13, n8, n11 - (n13 - n7), point.y);
                }
            }
            n9 = Math.max(n9, n8 += n4 + point.y);
            ++n12;
        }
        if (bl) {
            this.invalidateVisibleRegion(this.handle);
        }
        return new int[]{n10, n7 + n11, n9};
    }

    int[] layout(int n, int n2, boolean bl) {
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(n, n2, bl);
        }
        return this.layoutHorizontal(n, n2, bl);
    }

    void relayout() {
        if (this.drawCount > 0) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        this.layout(rectangle.width, rectangle.height, true);
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.itemCount) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.release(false);
                }
                ++n;
            }
            this.itemCount = 0;
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    void setBackground(float[] fArray) {
        super.setBackground(fArray);
        if (this.items == null) {
            return;
        }
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            toolItem.setBackground(fArray);
            ++n;
        }
        this.redrawWidget(this.handle, true);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if ((n5 & 0x80) != 0) {
            this.relayout();
        }
        return n5;
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            toolItem.setFontStyle(font);
            ++n;
        }
        this.redrawWidget(this.handle, true);
        this.relayout();
    }

    void setForeground(float[] fArray) {
        super.setForeground(fArray);
        if (this.items == null) {
            return;
        }
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            toolItem.setForeground(fArray);
            ++n;
        }
        this.redrawWidget(this.handle, true);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            this.relayout();
        }
    }
}

