package tle.searchutil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import tle.searchutil.impl.CondAnd;
import tle.searchutil.impl.CondBetween;
import tle.searchutil.impl.CondEmpty;
import tle.searchutil.impl.CondEq;
import tle.searchutil.impl.CondEqProperty;
import tle.searchutil.impl.CondGe;
import tle.searchutil.impl.CondGeProperty;
import tle.searchutil.impl.CondGt;
import tle.searchutil.impl.CondGtProperty;
import tle.searchutil.impl.CondIdEq;
import tle.searchutil.impl.CondIlike;
import tle.searchutil.impl.CondIn;
import tle.searchutil.impl.CondLe;
import tle.searchutil.impl.CondLeProperty;
import tle.searchutil.impl.CondLike;
import tle.searchutil.impl.CondLt;
import tle.searchutil.impl.CondLtProperty;
import tle.searchutil.impl.CondNe;
import tle.searchutil.impl.CondNeProperty;
import tle.searchutil.impl.CondNot;
import tle.searchutil.impl.CondNotEmpty;
import tle.searchutil.impl.CondNotIn;
import tle.searchutil.impl.CondNotNull;
import tle.searchutil.impl.CondNull;
import tle.searchutil.impl.CondOr;

public class QueryHelper {
	
	protected Map operationMap;
	
	public QueryHelper() {
		operationMap = new HashMap();
		operationMap.put(CondEq.class, "=");
		operationMap.put(CondEqProperty.class, "=");
		operationMap.put(CondGe.class, ">=");
		operationMap.put(CondGeProperty.class, ">=");
		operationMap.put(CondGt.class, ">");
		operationMap.put(CondGtProperty.class, ">");
		operationMap.put(CondIdEq.class, "=");
		operationMap.put(CondIlike.class, "ilike");
		operationMap.put(CondLe.class, "<=");
		operationMap.put(CondLeProperty.class, "<=");
		operationMap.put(CondLike.class, "like");
		operationMap.put(CondLt.class, "<");
		operationMap.put(CondLtProperty.class, "<");
		operationMap.put(CondNe.class, "<>");
		operationMap.put(CondNeProperty.class, "<>");
		
		operationMap.put(CondAnd.class, "and");
		operationMap.put(CondOr.class, "or");
		operationMap.put(CondNot.class, "not");
		
		operationMap.put(CondEmpty.class, "is empty");
		operationMap.put(CondNotEmpty.class, "is not empty");
		operationMap.put(CondNull.class, "is null");
		operationMap.put(CondNotNull.class, "is not null");
		
		operationMap.put(CondIn.class, "in");
		operationMap.put(CondNotIn.class, "not in");
	}

	/**
	 * where κп Ե  Ѵ.
	 * <p>
	 *  κ Ķͷ üǸ, 
	 * ĶͿ Ե  ˸   List Ѵ.
	 * 
	 * @param filter
	 * @param alias  ƼƼ(Ǵ ̺) alias
	 * @param buffer    StringBuffer
	 * @return
	 */
	public List appendWherePart(SearchFilter filter, String alias,
			StringBuffer buffer) {
		if (buffer == null) buffer = new StringBuffer(filter.sizeConds() * 15);
		List parameterValues = new ArrayList(8);
		
		Stack stackList = new Stack(); //  List
		Stack stacki = new Stack(); //  i 
		Stack stackComposite = new Stack(); //  composite OP
		
		Cond currentCompositeOp = new CondAnd();  
		
		//String currentCompositeOp =  
		//	(String)operationMap.get(CondAnd.class);
		
		List conds = filter.getConds();
		
		for (int i = 0 ; i <= conds.size() ; i++) {
			if (i == 0) {
				if (currentCompositeOp instanceof CondNot) {
					buffer.append("not ");
				} else {
					buffer.append("(");
				}
			}
			
			if (i == conds.size()) {
				if (!(currentCompositeOp instanceof CondNot)) {
					buffer.append(")");
				}
				
				// stack  ִ  ˻Ѵ.
				if (stackList.size() > 0) {
					conds = (List)stackList.pop();
					i = ((Integer)stacki.pop()).intValue();
					currentCompositeOp = (Cond)stackComposite.pop();
				}
				continue;
			}
			
			if (i > 0 && i < conds.size() ) {
				if (currentCompositeOp instanceof CondAnd ||
						currentCompositeOp instanceof CondOr) {
					buffer.append(" ")
					      .append((String)operationMap.get(currentCompositeOp.getClass()) )
					      .append(" ");
			
				}
			}
			
			Cond cond = (Cond)conds.get(i);
			if (cond instanceof CompositeCond) {
				stackList.push(conds);
				stacki.push(new Integer(i));
				stackComposite.push(currentCompositeOp);
				
				CompositeCond comCond = (CompositeCond)cond;
				currentCompositeOp = comCond;
				conds = comCond.getConds();
				i = -1;
				//currentCompositeOp = (String)operationMap.get(comCond.getClass());
			} else if (cond instanceof SingleCond) {
				stackList.push(conds);
				stacki.push(new Integer(i));
				stackComposite.push(currentCompositeOp);
				
				SingleCond singleCond = (SingleCond)cond;
				currentCompositeOp = singleCond;
				List tempList = new ArrayList(1);
				tempList.add(singleCond.getCond());
				conds = tempList;
				i = -1;
			} else {
				appendQuery((PropertyCond)cond, alias, buffer, parameterValues);
			}
		}
		
		return parameterValues;
	}
	
	/**
	 * cond شϴ  buffer ߰Ѵ.
	 * 
	 * @param cond
	 * @param alias
	 * @param buffer
	 * @param parameterValues
	 */
	protected void appendQuery(PropertyCond cond, String alias, 
			StringBuffer buffer, List parameterValues) {
		String propertyName = getQueryPropertyName(cond.getPropertyName(), alias);
		
		if (! (cond instanceof PropertyValuesCond)) {
			buffer.append(propertyName).append(" ");
			buffer.append((String)operationMap.get(cond.getClass()));
			if (cond instanceof TwoPropertyCond) {
				buffer.append(" ")
				      .append(getQueryPropertyName(
				    		  ((TwoPropertyCond)cond).getOtherPropertyName(), alias
				    		  ));
			} else if (cond instanceof PropertyValueCond) {
				buffer.append(" ?");
				if (cond instanceof CondLike) {
					// like ˻ 
					CondLike likeCond = (CondLike)cond;
					if (likeCond.getMatch() == Match.ANYWHERE) {
						parameterValues.add("%"+likeCond.getValueString()+"%");
					} else if (likeCond.getMatch() == Match.START) {
						parameterValues.add(likeCond.getValueString()+"%");
					} else if (likeCond.getMatch() == Match.END) {
						parameterValues.add("%"+likeCond.getValueString());
					} else {
						parameterValues.add(likeCond.getValueString());
					}
				} else {
					parameterValues.add(((PropertyValueCond)cond).getValue());
				}
			}
		} else {
			buffer.append(propertyName).append(" ");
			
			PropertyValuesCond valuesCond = (PropertyValuesCond)cond;
			if (valuesCond instanceof CondIn ||
					valuesCond instanceof CondNotIn) {
				
				buffer.append((String)operationMap.get(valuesCond.getClass()))
				      .append(" (");
				List valueList = valuesCond.getValues();
				for (int i = 0 ; i < valueList.size() ; i++) {
					buffer.append("?");
					parameterValues.add(valueList.get(i));
					if (i < valueList.size() - 1) {
						buffer.append(",");
					}
				}
				buffer.append(")");
			} else if (valuesCond instanceof CondBetween) {
				buffer.append("between ? and ?");
				parameterValues.add(((CondBetween)valuesCond).getLo());
				parameterValues.add(((CondBetween)valuesCond).getHi());
			}
		}
	}
	
	/**
	 * order by κп Ե  Ѵ.
	 * 
	 * @param filter
	 * @param alias
	 * @param buffer
	 * @return
	 */
	public StringBuffer appendOrderPart(SearchFilter filter, String alias, StringBuffer buffer) {
		if (buffer == null) buffer = new StringBuffer(filter.sizeConds() * 15);
		List orderList = filter.getOrders();
		for (int i = 0 ; i < orderList.size() ; i++) {
			Order order = (Order)orderList.get(i);
			buffer.append(getQueryPropertyName(order.getPropertyName(), alias))
			      .append(" ")
			      .append(order.isAscending() ? "asc" : "desc");
			if (i < orderList.size() - 1) {
				buffer.append(", ");
			}
		}
		return buffer;
	}
	
	/**
	 *   Ƽ ̸ Ѵ. 
	 * @param propertyName
	 * @param alias
	 * @return
	 */
	protected String getQueryPropertyName(String propertyName, String alias) {
		return (alias == null || alias.equals("") ? "" : alias + "." ) + propertyName;
	}
}
