package tle.searchutil.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

import tle.searchutil.OneZero;
import tle.searchutil.QueryHelper;
import tle.searchutil.TrueFalse;
import tle.searchutil.YesNo;

/**
 * SQL PreparedStatement ĶͿ
 * ˸  ϴ  ߰ ߴ.
 * @author ֹ
 *
 */
public class SQLQueryHelper extends QueryHelper {
	
	/**
	 * @param pstmt
	 * @param startIdx 1.
	 * @param parameterValues
	 * @throws SQLException 
	 */
	public void setParameter(PreparedStatement pstmt,  
			int startIdx, List parameterValues) throws SQLException {
		for (int i = 0 ; i < parameterValues.size() ; i++) {
			Object value = parameterValues.get(i);
			setValue(pstmt, i + startIdx, value);
		}
	}
	
	/**
	 * Ķ  ŸԿ  ˸° óѴ.
	 * @param pstmt
	 * @param idx
	 * @param value
	 * @throws SQLException
	 */
	protected void setValue(PreparedStatement pstmt, int idx, Object value) throws SQLException {
		if (value instanceof YesNo) {
			pstmt.setString(idx, ((YesNo)value).getValue().booleanValue() ? "Y" : "N");
		} else if (value instanceof TrueFalse) {
			pstmt.setString(idx, ((TrueFalse)value).getValue().booleanValue() ? "T" : "F");
		} else if (value instanceof OneZero) {
			pstmt.setInt(idx, ((OneZero)value).getValue().booleanValue() ? 1 : 0);
		} else if (value instanceof Number){
			if (value instanceof Long) {
				pstmt.setLong(idx, ((Long)value).longValue());
			} else if (value instanceof Short) {
				pstmt.setShort(idx, ((Short)value).shortValue());
			} else if (value instanceof Byte) {
				pstmt.setByte(idx, ((Byte)value).byteValue());
			} else if (value instanceof Float) {
				pstmt.setFloat(idx, ((Float)value).floatValue());
			} else if (value instanceof Double) {
				pstmt.setDouble(idx, ((Double)value).doubleValue());
			} else {
				pstmt.setInt(idx, ((Number)value).intValue());
			}
		} else if (value instanceof java.util.Date) {
			Date dValue = (Date)value;
			pstmt.setTimestamp(idx, new java.sql.Timestamp(dValue.getTime()));
		} else if (value instanceof java.sql.Timestamp) {
			pstmt.setTimestamp(idx, (java.sql.Timestamp)value);
		} else if (value instanceof java.sql.Date) {
			pstmt.setDate(idx, (java.sql.Date)value);
		} else if (value instanceof java.sql.Time) {
			pstmt.setTime(idx, (java.sql.Time)value);
		} else {
			pstmt.setString(idx, value.toString());
		}
		
	}
}
